/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils.tokenizer;

import gnu.trove.stack.TIntStack;
import gnu.trove.stack.array.TIntArrayStack;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;

public class SymbolTokenizer<T extends Token> {
    @Nonnull
    protected CharacterRules characterRules;
    @Nonnull
    protected TokenFactory<T> tokenFactory;

    public SymbolTokenizer(@Nonnull CharacterRules characterRules, @Nonnull TokenFactory tokenFactory) {
        this.characterRules = characterRules;
        this.tokenFactory = tokenFactory;
    }

    @Nonnull
    public CharacterRules getCharacterRules() {
        return this.characterRules;
    }

    public void setCharacterRules(@Nonnull CharacterRules characterRules) {
        this.characterRules = characterRules;
    }

    @Nonnull
    public TokenFactory getTokenFactory() {
        return this.tokenFactory;
    }

    public void setTokenFactory(@Nonnull TokenFactory tokenFactory) {
        this.tokenFactory = tokenFactory;
    }

    public List<T> tokenize(String string) throws ParseException {
        Character escapeChar = this.characterRules.escapeChar();
        Character literalChar = this.characterRules.literalChar();
        int index = 0;
        int variableStart = -1;
        int literalStart = -1;
        boolean escape = false;
        TIntArrayStack escapes = new TIntArrayStack();
        ArrayList<T> tokens = new ArrayList<T>();
        while (index < string.length()) {
            char character = string.charAt(index);
            if (this.characterRules.isIllegal(character)) {
                throw new ParseException(String.format("Illegal character '%c'", Character.valueOf(character)), index);
            }
            if (!escape && escapeChar != null && escapeChar.charValue() == character) {
                escape = true;
                escapes.push(index);
                if (variableStart < 0 && literalStart < 0) {
                    variableStart = index;
                }
            } else if (literalStart >= 0) {
                if (!escape && literalChar != null && literalChar.charValue() == character) {
                    tokens.add(this.constructStringToken(string, literalStart + 1, literalStart, index, (TIntStack)escapes));
                    literalStart = -1;
                }
                escape = false;
            } else if (!escape && literalChar != null && literalChar.charValue() == character) {
                if (variableStart >= 0) {
                    tokens.add(this.constructStringToken(string, variableStart, variableStart, index, (TIntStack)escapes));
                }
                literalStart = index;
            } else if (!escape && this.characterRules.isWhitespace(character)) {
                if (variableStart >= 0) {
                    tokens.add(this.constructStringToken(string, variableStart, variableStart, index, (TIntStack)escapes));
                }
                variableStart = -1;
            } else {
                T token;
                if (!escape && (token = this.tokenFactory.tryConstructSymbolTokenAt(index, string)) != null) {
                    if (variableStart >= 0) {
                        tokens.add(this.constructStringToken(string, variableStart, variableStart, index, (TIntStack)escapes));
                    }
                    variableStart = -1;
                    tokens.add(token);
                    index = ((Token)token).endIndex;
                    continue;
                }
                if (variableStart < 0) {
                    variableStart = index;
                }
                escape = false;
            }
            ++index;
        }
        if (literalStart >= 0) {
            throw new ParseException(String.format("Unclosed literal '%c'", literalChar), index);
        }
        if (escape) {
            throw new ParseException(String.format("Unclosed escape '%c'", escapeChar), index);
        }
        if (variableStart >= 0) {
            tokens.add(this.constructStringToken(string, variableStart, variableStart, index, (TIntStack)escapes));
        }
        tokens.trimToSize();
        return tokens;
    }

    public String escapeWhereNecessary(String string) {
        Character escapeChar = this.characterRules.escapeChar();
        if (escapeChar != null) {
            TIntArrayStack escapes = new TIntArrayStack();
            for (int idx = 0; idx < string.length(); ++idx) {
                if (!this.characterRules.isWhitespace(string.charAt(idx)) && this.tokenFactory.tryConstructSymbolTokenAt(idx, string) == null) continue;
                escapes.push(idx);
            }
            if (escapes.size() > 0) {
                StringBuilder builder = new StringBuilder(string);
                while (escapes.size() > 0) {
                    builder.insert(escapes.pop(), escapeChar);
                }
                return builder.toString();
            }
        }
        return string;
    }

    protected T constructStringToken(String string, int start, int varStart, int end, TIntStack escapes) {
        StringBuilder constant = new StringBuilder(string.substring(start, end));
        while (escapes.size() > 0) {
            constant.deleteCharAt(escapes.pop() - start);
        }
        escapes.clear();
        return this.tokenFactory.constructStringToken(varStart, constant.toString());
    }

    protected boolean hasAt(String string, String symbol, int index) {
        return string.regionMatches(index, symbol, 0, symbol.length());
    }

    public static class SimpleCharacterRules
    implements CharacterRules {
        @Nullable
        private Character escapeChar;
        @Nullable
        private Character literalChar;
        @Nullable
        private char[] whitespace;
        @Nullable
        private char[] illegal;

        public SimpleCharacterRules() {
            this(Character.valueOf('\\'), Character.valueOf('\"'), null, null);
        }

        public SimpleCharacterRules(Character escapeChar, Character literalChar, char[] whitespace, char[] illegal) {
            this.escapeChar = escapeChar;
            this.literalChar = literalChar;
            this.whitespace = whitespace;
            this.illegal = illegal;
        }

        @Nullable
        public Character getEscapeChar() {
            return this.escapeChar;
        }

        public void setEscapeChar(@Nullable Character escapeChar) {
            this.escapeChar = escapeChar;
        }

        @Nullable
        public Character getLiteralChar() {
            return this.literalChar;
        }

        public void setLiteralChar(@Nullable Character literalChar) {
            this.literalChar = literalChar;
        }

        @Nullable
        public char[] getWhitespace() {
            return this.whitespace;
        }

        public void setWhitespace(@Nullable char[] whitespace) {
            this.whitespace = whitespace;
        }

        @Nullable
        public char[] getIllegal() {
            return this.illegal;
        }

        public void setIllegal(@Nullable char[] illegal) {
            this.illegal = illegal;
        }

        @Override
        public boolean isWhitespace(char character) {
            return this.whitespace != null ? ArrayUtils.contains((char[])this.whitespace, (char)character) : Character.isWhitespace(character);
        }

        @Override
        public Character escapeChar() {
            return this.escapeChar;
        }

        @Override
        public Character literalChar() {
            return this.literalChar;
        }

        @Override
        public boolean isIllegal(char character) {
            return this.illegal != null && ArrayUtils.contains((char[])this.illegal, (char)character);
        }
    }

    public static interface CharacterRules {
        @Nullable
        public Character escapeChar();

        @Nullable
        public Character literalChar();

        public boolean isWhitespace(char var1);

        public boolean isIllegal(char var1);
    }

    public static interface TokenFactory<T extends Token> {
        @Nullable
        public T tryConstructSymbolTokenAt(int var1, @Nonnull String var2);

        @Nonnull
        public T constructStringToken(int var1, @Nonnull String var2);
    }

    public static abstract class Token {
        public final int startIndex;
        public final int endIndex;

        public Token(int startIndex, int endIndex) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }
    }
}

