/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.client.rendering;

import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.reccomplex.world.gen.feature.structure.generic.Selection;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class MazeVisualizationContext {
    protected BlockPos lowerCoord;
    protected int[] scale;

    public MazeVisualizationContext(BlockPos lowerCoord, int[] scale) {
        int[] nArray;
        this.lowerCoord = lowerCoord;
        if (scale != null) {
            nArray = scale;
        } else {
            int[] nArray2 = new int[3];
            nArray2[0] = 1;
            nArray2[1] = 1;
            nArray = nArray2;
            nArray2[2] = 1;
        }
        this.scale = nArray;
    }

    @Nonnull
    public Selection mapSelection(Selection selection) {
        Selection realWorldSelection = new Selection(3);
        for (Selection.Area area : selection) {
            BlockPos min = this.min(new MazeRoom(area.getMinCoord()));
            BlockPos max = this.max(new MazeRoom(area.getMaxCoord()));
            realWorldSelection.add(Selection.Area.from(area.isAdditive(), BlockPositions.toIntArray((BlockPos)min), BlockPositions.toIntArray((BlockPos)max), area.getIdentifier()));
        }
        return realWorldSelection;
    }

    @Nonnull
    protected BlockPos apply(int[] coordinates) {
        return this.lowerCoord.func_177971_a((Vec3i)BlockPositions.fromIntArray((int[])IvVecMathHelper.mul((int[][])new int[][]{this.scale, coordinates})));
    }

    public BlockPos min(MazeRoom room) {
        return this.apply(room.getCoordinates());
    }

    public BlockPos max(MazeRoom room) {
        int[] one = new int[room.getDimensions()];
        Arrays.fill(one, 1);
        return this.apply(IvVecMathHelper.add((int[][])new int[][]{room.getCoordinates(), one})).func_177973_b(new Vec3i(1, 1, 1));
    }
}

