/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import hunternif.mc.atlas.registry.IRegistryEntry;
import hunternif.mc.atlas.registry.MarkerRenderInfo;
import hunternif.mc.atlas.util.BitMatrix;
import hunternif.mc.atlas.util.Log;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class MarkerType
extends IRegistryEntry.Impl {
    private ResourceLocation[] icons;
    private BitMatrix[] iconPixels;
    private int[] iconSizes = null;
    private int viewSize = 2;
    private int clipMin = -1000;
    private int clipMax = 1000;
    private boolean alwaysShow = false;
    private boolean isTile = false;
    private boolean isTechnical = false;
    private double centerX = 0.5;
    private double centerY = 0.5;
    private boolean isFromJson = false;
    private final JSONData data = new JSONData(this);
    private int iconIndex = 0;

    public MarkerType(ResourceLocation loc, ResourceLocation ... icons) {
        if (loc == null) {
            throw new IllegalArgumentException("MarkerType registry name can't be null");
        }
        this.setRegistryName(loc);
        this.icons = icons;
    }

    public boolean isTechnical() {
        return this.isTechnical;
    }

    public boolean shouldHide(boolean isHidingMarkers, int scaleIndex) {
        return this.shouldClip(scaleIndex) || !this.alwaysShow && isHidingMarkers;
    }

    private boolean shouldClip(int scaleIndex) {
        return scaleIndex < this.clipMin || scaleIndex > this.clipMax;
    }

    public boolean shouldHover(double x, double y) {
        if (this.isTechnical() || x > 1.0 || x < 0.0 || y > 1.0 || y < 0.0) {
            return false;
        }
        if (this.iconPixels == null || this.iconPixels.length == 0 || this.iconIndex < 0) {
            return true;
        }
        int iconX = (int)((double)this.iconPixels[this.iconIndex].getWidth() * x);
        int iconY = (int)((double)this.iconPixels[this.iconIndex].getHeight() * y);
        return this.iconPixels[this.iconIndex].get(iconX, iconY);
    }

    private int viewSize() {
        return this.viewSize;
    }

    private boolean isTile() {
        return this.isTile;
    }

    private double getCenterX() {
        return this.centerX;
    }

    private double getCenterY() {
        return this.centerY;
    }

    public ResourceLocation getIcon() {
        return this.icons.length == 0 || this.iconIndex < 0 ? TextureMap.field_174945_f : this.icons[this.iconIndex];
    }

    public ResourceLocation[] getAllIcons() {
        return this.icons;
    }

    public void calculateMip(double scale, double mapScale, double screenScale) {
        int size = (int)(16.0 * scale * (double)this.viewSize());
        if (this.isTile) {
            size = (int)((double)size * mapScale);
        }
        if (this.icons.length > 1) {
            int smallestSide = (int)((double)size * screenScale);
            int closestValue = Integer.MAX_VALUE;
            int closestIndex = -1;
            for (int i = 0; i < this.iconSizes.length; ++i) {
                if (this.iconSizes[i] >= closestValue || this.iconSizes[i] < smallestSide) continue;
                closestValue = this.iconSizes[i];
                closestIndex = i;
            }
            if (closestIndex > 0) {
                this.iconIndex = closestIndex;
            }
        }
    }

    public void resetMip() {
        this.iconIndex = 0;
    }

    public MarkerRenderInfo getRenderInfo(double scale, double mapScale, double screenScale) {
        boolean isTile = this.isTile();
        int size = (int)(16.0 * scale * (double)this.viewSize());
        if (isTile) {
            size = (int)((double)size * mapScale);
        }
        int x = -((int)((double)size * this.getCenterX()));
        int y = -((int)((double)size * this.getCenterY()));
        ResourceLocation icon = this.getIcon();
        return new MarkerRenderInfo(icon, x, y, size, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initMips() {
        this.iconSizes = new int[this.icons.length];
        this.iconPixels = new BitMatrix[this.icons.length];
        int ALPHA_THRESHOLD = 8;
        for (int i = 0; i < this.icons.length; ++i) {
            this.iconSizes[i] = -1;
            if (this.icons[i] == null) {
                Log.warn("Marker %s -- Texture location is null at index %d!", this.getRegistryName().toString(), i);
            }
            IResource iresource = null;
            try {
                iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.icons[i]);
                BufferedImage bufferedimage = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
                this.iconSizes[i] = Math.min(bufferedimage.getWidth(), bufferedimage.getHeight());
                BitMatrix matrix = new BitMatrix(bufferedimage.getWidth(), bufferedimage.getHeight(), false);
                for (int x = 0; x < bufferedimage.getWidth(); ++x) {
                    for (int y = 0; y < bufferedimage.getHeight(); ++y) {
                        int color = bufferedimage.getRGB(x, y);
                        int alpha = color >> 24 & 0xFF;
                        if (alpha < ALPHA_THRESHOLD) continue;
                        matrix.set(x, y, true);
                        matrix.set(x - 1, y, true);
                        matrix.set(x + 1, y, true);
                        matrix.set(x, y - 1, true);
                        matrix.set(x, y + 1, true);
                        matrix.set(x + 1, y + 1, true);
                        matrix.set(x - 1, y - 1, true);
                        matrix.set(x + 1, y - 1, true);
                        matrix.set(x - 1, y + 1, true);
                    }
                }
                this.iconPixels[i] = matrix;
            }
            catch (IOException e) {
                try {
                    Log.warn(e, "Marker %s -- Error getting texture size data for index %d - %s", this.getRegistryName().toString(), i, this.icons[i].toString());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(iresource);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)iresource);
                continue;
            }
            IOUtils.closeQuietly((Closeable)iresource);
            continue;
        }
    }

    public MarkerType setSize(int value) {
        this.viewSize = value;
        return this;
    }

    public MarkerType setIsTile(boolean value) {
        this.isTile = value;
        return this;
    }

    public MarkerType setAlwaysShow(boolean value) {
        this.alwaysShow = value;
        return this;
    }

    public MarkerType setClip(int min, int max) {
        this.clipMin = Math.min(min, max);
        this.clipMax = Math.max(min, max);
        return this;
    }

    public MarkerType setCenter(double x, double y) {
        this.centerX = x;
        this.centerY = y;
        return this;
    }

    public MarkerType setIsTechnical(boolean value) {
        this.isTechnical = value;
        return this;
    }

    public MarkerType setIsFromJson(boolean value) {
        this.isFromJson = value;
        return this;
    }

    public JSONData getJSONData() {
        return this.data;
    }

    static /* synthetic */ ResourceLocation[] access$002(MarkerType x0, ResourceLocation[] x1) {
        x0.icons = x1;
        return x1;
    }

    public static class JSONData {
        static final String ICONS = "textures";
        static final String SIZE = "size";
        static final String CLIP_MIN = "clipMin";
        static final String CLIP_MAX = "clipMax";
        static final String ALWAYS_SHOW = "alwaysShow";
        static final String IS_TILE = "isTile";
        static final String IS_TECH = "isTechnical";
        static final String CENTER_X = "centerX";
        static final String CENTER_Y = "centerY";
        static final String NONE = "NONE";
        private final MarkerType type;
        ResourceLocation[] icons;
        Integer viewSize = null;
        Integer clipMin = null;
        Integer clipMax = null;
        Boolean alwaysShow = null;
        Boolean isTile = null;
        Boolean isTechnical = null;
        Double centerX = null;
        Double centerY = null;

        JSONData(MarkerType type) {
            this.type = type;
        }

        public void saveTo(JsonObject object) {
            if (this.icons != null) {
                JsonArray arr = new JsonArray();
                for (ResourceLocation loc : this.icons) {
                    arr.add((JsonElement)new JsonPrimitive(loc.toString()));
                }
                object.add(ICONS, (JsonElement)arr);
            }
            if (this.viewSize != null) {
                object.addProperty(SIZE, (Number)this.viewSize);
            }
            if (this.clipMin != null) {
                object.addProperty(CLIP_MIN, (Number)this.clipMin);
            }
            if (this.clipMax != null) {
                object.addProperty(CLIP_MAX, (Number)this.clipMax);
            }
            if (this.alwaysShow != null) {
                object.addProperty(ALWAYS_SHOW, this.alwaysShow);
            }
            if (this.isTile != null) {
                object.addProperty(IS_TILE, this.isTile);
            }
            if (this.isTechnical != null) {
                object.addProperty(IS_TECH, this.isTechnical);
            }
            if (this.centerX != null) {
                object.addProperty(CENTER_X, (Number)this.centerX);
            }
            if (this.centerY != null) {
                object.addProperty(CENTER_Y, (Number)this.centerY);
            }
        }

        public void readFrom(JsonObject object) {
            if (object.entrySet().size() == 0) {
                return;
            }
            String typeName = this.type.getRegistryName().toString();
            String workingOn = NONE;
            try {
                if (object.has(ICONS) && object.get(ICONS).isJsonArray()) {
                    workingOn = ICONS;
                    ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
                    int i = 0;
                    for (JsonElement elem : object.get(ICONS).getAsJsonArray()) {
                        if (elem.isJsonPrimitive()) {
                            list.add(new ResourceLocation(elem.getAsString()));
                        } else {
                            Log.warn("Loading marker %s from JSON: Texture item %d isn't a primitive", typeName, i);
                        }
                        ++i;
                    }
                    this.icons = list.toArray(new ResourceLocation[0]);
                    workingOn = NONE;
                }
                if (object.has(SIZE) && object.get(SIZE).isJsonPrimitive()) {
                    workingOn = SIZE;
                    this.viewSize = object.get(SIZE).getAsInt();
                    workingOn = NONE;
                }
                if (object.has(CLIP_MIN) && object.get(CLIP_MIN).isJsonPrimitive()) {
                    workingOn = CLIP_MIN;
                    this.clipMin = object.get(CLIP_MIN).getAsInt();
                    workingOn = NONE;
                }
                if (object.has(CLIP_MAX) && object.get(CLIP_MAX).isJsonPrimitive()) {
                    workingOn = CLIP_MAX;
                    this.clipMax = object.get(CLIP_MAX).getAsInt();
                    workingOn = NONE;
                }
                if (object.has(ALWAYS_SHOW) && object.get(ALWAYS_SHOW).isJsonPrimitive()) {
                    workingOn = ALWAYS_SHOW;
                    this.alwaysShow = object.get(ALWAYS_SHOW).getAsBoolean();
                    workingOn = NONE;
                }
                if (object.has(IS_TILE) && object.get(IS_TILE).isJsonPrimitive()) {
                    workingOn = IS_TILE;
                    this.isTile = object.get(IS_TILE).getAsBoolean();
                    workingOn = NONE;
                }
                if (object.has(IS_TECH) && object.get(IS_TECH).isJsonPrimitive()) {
                    workingOn = IS_TECH;
                    this.isTechnical = object.get(IS_TECH).getAsBoolean();
                    workingOn = NONE;
                }
                if (object.has(CENTER_X) && object.get(CENTER_X).isJsonPrimitive()) {
                    workingOn = CENTER_X;
                    this.centerX = object.get(CENTER_X).getAsDouble();
                    workingOn = NONE;
                }
                if (object.has(CENTER_Y) && object.get(CENTER_Y).isJsonPrimitive()) {
                    workingOn = CENTER_Y;
                    this.centerY = object.get(CENTER_Y).getAsDouble();
                    workingOn = NONE;
                }
            }
            catch (ClassCastException e) {
                Log.warn(e, "Loading marker $s from JSON: Parsing element %s: element was wrong type!", typeName, workingOn);
            }
            catch (NumberFormatException e) {
                Log.warn(e, "Loading marker $s from JSON: Parsing element %s: element was an invalid number!", typeName, workingOn);
            }
            if (this.icons != null) {
                MarkerType.access$002(this.type, this.icons);
            }
            if (this.viewSize != null) {
                this.type.viewSize = this.viewSize;
            }
            if (this.clipMin != null) {
                this.type.clipMin = this.clipMin;
            }
            if (this.clipMax != null) {
                this.type.clipMax = this.clipMax;
            }
            if (this.alwaysShow != null) {
                this.type.alwaysShow = this.alwaysShow;
            }
            if (this.isTile != null) {
                this.type.isTile = this.isTile;
            }
            if (this.isTechnical != null) {
                this.type.isTechnical = this.isTechnical;
            }
            if (this.centerX != null) {
                this.type.centerX = this.centerX;
            }
            if (this.centerY != null) {
                this.type.centerY = this.centerY;
            }
        }
    }
}

