/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks.block;

import javax.annotation.Nonnull;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.network.InspirationsNetwork;
import knightminer.inspirations.common.network.RenderBlockUpdatePacket;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.util.TextureBlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.client.ModelHelper;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.mantle.property.PropertyString;

public class BlockBetterFlowerPot
extends BlockFlowerPot {
    public static final PropertyBool EXTRA = PropertyBool.func_177716_a((String)"extra");
    public static final PropertyString TEXTURE = TextureBlockUtil.TEXTURE_PROP;
    public static final String TAG_TEXTURE_PATH = "texture_path";

    public BlockBetterFlowerPot() {
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149663_c("flowerPot");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176443_b, (Comparable)BlockFlowerPot.EnumFlowerType.EMPTY).func_177226_a((IProperty)field_176444_a, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)EXTRA, (Comparable)Boolean.valueOf(false)));
    }

    protected ExtendedBlockState createBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[]{field_176443_b, field_176444_a, EXTRA}, new IUnlistedProperty[]{TEXTURE});
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileEntityFlowerPot)) {
            return false;
        }
        TileEntityFlowerPot flowerPot = (TileEntityFlowerPot)te;
        ItemStack flower = flowerPot.func_184403_b();
        if (flower.func_190926_b()) {
            if (!InspirationsRegistry.isFlower(stack)) {
                return false;
            }
            flowerPot.func_190614_a(stack);
            flowerPot.getTileData().func_82580_o(TAG_TEXTURE_PATH);
            player.func_71029_a(StatList.field_188088_V);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        } else {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)flower, (int)player.field_71071_by.field_70461_c);
            flowerPot.func_190614_a(ItemStack.field_190927_a);
        }
        flowerPot.func_70296_d();
        world.func_184138_a(pos, state, state, 3);
        InspirationsNetwork.sendToClients(world, pos, (AbstractPacket)new RenderBlockUpdatePacket(pos));
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        if ((state = super.func_176221_a(state, world, pos)).func_177229_b((IProperty)field_176443_b) == BlockFlowerPot.EnumFlowerType.EMPTY && (te = world.func_175625_s(pos)) instanceof TileEntityFlowerPot && !((TileEntityFlowerPot)te).func_184403_b().func_190926_b()) {
            state = state.func_177226_a((IProperty)EXTRA, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)EXTRA)).booleanValue()) {
            return state;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityFlowerPot) {
            Block block;
            ItemStack stack;
            TileEntityFlowerPot flowerPot = (TileEntityFlowerPot)te;
            String texture = flowerPot.getTileData().func_74779_i(TAG_TEXTURE_PATH);
            if (texture.isEmpty() && !(stack = flowerPot.func_184403_b()).func_190926_b() && (block = Block.func_149634_a((Item)stack.func_77973_b())) != Blocks.field_150350_a) {
                texture = ModelHelper.getTextureFromBlock((Block)block, (int)stack.func_77952_i()).func_94215_i();
                flowerPot.getTileData().func_74778_a(TAG_TEXTURE_PATH, texture);
            }
            if (!texture.isEmpty()) {
                state = ((IExtendedBlockState)state).withProperty((IUnlistedProperty)TEXTURE, (Object)texture);
            }
        }
        return state;
    }

    @Deprecated
    public boolean func_149740_M(IBlockState state) {
        return Config.flowerPotComparator;
    }

    @Deprecated
    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        if (!Config.flowerPotComparator) {
            return 0;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityFlowerPot) {
            return this.getComparatorSignal(((TileEntityFlowerPot)te).func_184403_b());
        }
        return 0;
    }

    private int getComparatorSignal(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        return InspirationsRegistry.getFlowerComparatorPower(stack);
    }
}

