/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.plugins.jei.cauldron.ingredient;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.plugins.jei.cauldron.ingredient.DyeIngredient;
import knightminer.inspirations.recipes.InspirationsRecipes;
import mezz.jei.api.ingredients.IIngredientHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum DyeIngredientHelper implements IIngredientHelper<DyeIngredient>
{
    INSTANCE;

    public static final List<DyeIngredient> ALL_DYES;

    public List<DyeIngredient> expandSubtypes(List<DyeIngredient> ingredients) {
        return ingredients;
    }

    public DyeIngredient getMatch(Iterable<DyeIngredient> ingredients, DyeIngredient match) {
        for (DyeIngredient dye : ingredients) {
            if (dye.getDye() != match.getDye()) continue;
            return dye;
        }
        return null;
    }

    public String getDisplayName(DyeIngredient ingredient) {
        return Util.translateFormatted("gui.jei.cauldron.color", Util.translate("item.fireworksCharge.%s", ingredient.getDye().func_176762_d()));
    }

    public String getUniqueId(DyeIngredient ingredient) {
        return this.getResourceId(ingredient);
    }

    public String getWildcardId(DyeIngredient ingredient) {
        return this.getUniqueId(ingredient);
    }

    public String getModId(DyeIngredient ingredient) {
        return "inspirations";
    }

    public Iterable<Color> getColors(DyeIngredient ingredient) {
        return ImmutableList.of((Object)new Color(ingredient.getDye().field_193351_w));
    }

    public String getResourceId(DyeIngredient ingredient) {
        return ingredient.getDye().func_176610_l();
    }

    public DyeIngredient copyIngredient(DyeIngredient ingredient) {
        return ingredient;
    }

    public String getErrorInfo(DyeIngredient ingredient) {
        return ingredient != null && ingredient.getDye() != null ? this.getResourceId(ingredient) : null;
    }

    public ItemStack getCheatItemStack(DyeIngredient ingredient) {
        return new ItemStack((Item)InspirationsRecipes.dyedWaterBottle, 1, ingredient.getDye().func_176767_b());
    }

    static {
        ALL_DYES = Config.enableCauldronDyeing ? Arrays.stream(EnumDyeColor.values()).map(DyeIngredient::new).collect(Collectors.toList()) : Collections.emptyList();
    }
}

