/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.block;

import java.util.Locale;
import javax.annotation.Nonnull;
import knightminer.inspirations.building.tileentity.TileEnlightenedBush;
import knightminer.inspirations.library.client.ClientUtil;
import knightminer.inspirations.library.util.TextureBlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.mantle.property.PropertyString;

public class BlockEnlightenedBush
extends EnumBlock<LightsType>
implements ITileEntityProvider {
    public static final PropertyEnum<LightsType> LIGHTS = PropertyEnum.func_177709_a((String)"lights", LightsType.class);
    public static final PropertyString TEXTURE = TextureBlockUtil.TEXTURE_PROP;

    public BlockEnlightenedBush() {
        super(Material.field_151584_j, LIGHTS, LightsType.class);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_149715_a(1.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.field_149758_A = true;
    }

    @Nonnull
    protected ExtendedBlockState createBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[]{LIGHTS}, new IUnlistedProperty[]{TEXTURE});
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEnlightenedBush();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (LightsType type : LightsType.values()) {
            TextureBlockUtil.addBlocksFromOredict("treeLeaves", (Block)this, type.getMeta(), list);
        }
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        return ClientUtil.writeTextureBlockState(world, pos, state);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TextureBlockUtil.placeTextureBlock(world, pos, stack);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)TextureBlockUtil.getBlockItemStack(world, pos, state));
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return TextureBlockUtil.getBlockItemStack((IBlockAccess)world, pos, state);
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        this.func_176206_d(world, pos, state);
        if (willHarvest) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
        }
        world.func_175698_g(pos);
        return false;
    }

    public static enum LightsType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        WHITE,
        RED(0xBF0000),
        GREEN(2522880),
        BLUE(7359),
        RAINBOW,
        CHRISTMAS;

        private int meta = this.ordinal();
        private int color;

        private LightsType() {
            this(-1);
        }

        private LightsType(int color) {
            this.color = color;
        }

        public int getMeta() {
            return this.meta;
        }

        public int getColor() {
            return this.color;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.US);
        }

        public static LightsType fromMeta(int meta) {
            if (meta < 0 || meta >= LightsType.values().length) {
                meta = 0;
            }
            return LightsType.values()[meta];
        }
    }
}

