/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.event;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.silentchaos512.lib.util.AttributeHelper;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.api.event.BlightSpawnEvent;
import net.silentchaos512.scalinghealth.config.Config;
import net.silentchaos512.scalinghealth.event.BlightHandler;
import net.silentchaos512.scalinghealth.network.NetworkHandler;
import net.silentchaos512.scalinghealth.network.message.MessageDebugData;
import net.silentchaos512.scalinghealth.network.message.MessageMarkBlight;
import net.silentchaos512.scalinghealth.utils.EntityDifficultyChangeList;
import net.silentchaos512.scalinghealth.utils.EntityMatchList;
import net.silentchaos512.scalinghealth.utils.EquipmentTierMap;
import net.silentchaos512.scalinghealth.utils.MobPotionMap;
import net.silentchaos512.scalinghealth.utils.ModifierHandler;
import net.silentchaos512.scalinghealth.utils.SHPlayerDataHandler;
import net.silentchaos512.scalinghealth.world.ScalingHealthSavedData;
import net.silentchaos512.utils.MathUtils;

public class DifficultyHandler {
    public static final String NBT_ENTITY_DIFFICULTY = "scalinghealth:difficulty";
    public static DifficultyHandler INSTANCE = new DifficultyHandler();
    private static int POTION_APPLY_TIME = 12000;
    private static final String[] POTION_DEFAULTS = new String[]{"minecraft:strength,30,1", "minecraft:speed,10,1", "minecraft:speed,50,2", "minecraft:fire_resistance,10,1", "minecraft:invisibility,25,1", "minecraft:resistance,30,1"};
    private int debugMobsProcessed;
    private int serverTicks;
    public MobPotionMap potionMap = new MobPotionMap();
    private EntityEquipmentSlot[] ORDERED_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    public EquipmentTierMap mapHelmets = new EquipmentTierMap(5, EntityEquipmentSlot.HEAD);
    public EquipmentTierMap mapChestplates = new EquipmentTierMap(5, EntityEquipmentSlot.CHEST);
    public EquipmentTierMap mapLeggings = new EquipmentTierMap(5, EntityEquipmentSlot.LEGS);
    public EquipmentTierMap mapBoots = new EquipmentTierMap(5, EntityEquipmentSlot.FEET);
    public EquipmentTierMap mapMainhands = new EquipmentTierMap(5, EntityEquipmentSlot.MAINHAND);
    public EquipmentTierMap mapOffhands = new EquipmentTierMap(5, EntityEquipmentSlot.OFFHAND);

    public void initPotionMap() {
        String[] lines;
        this.potionMap.clear();
        for (String line : lines = Config.INSTANCE.getConfiguration().getStringList("Mob Potions", "main.mob.potion", POTION_DEFAULTS, "The potion effects that mobs can spawn with. You can add effects from other mods if you want to, or remove existing ones. Each line has 3 values separated by commas: the potion ID, the minimum difficulty (higher = less common), and the level (1 = level I, 2 = level II, etc).")) {
            String[] params = line.split(",");
            if (params.length >= 3) {
                int level;
                int minDiff;
                Potion potion;
                if (params.length > 3) {
                    ScalingHealth.logHelper.warn("Mob potion effects: extra parameters in line: " + line + ". Ignoring extra parameters and processing the first 3.", new Object[0]);
                }
                int index = -1;
                String id = "null";
                try {
                    id = params[++index];
                    potion = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation(id));
                    if (potion == null) {
                        throw new NullPointerException();
                    }
                    minDiff = Integer.parseInt(params[++index]);
                    level = Integer.parseInt(params[++index]);
                }
                catch (NumberFormatException ex) {
                    ScalingHealth.logHelper.warn("Mob potion effects: could not parse parameter " + index + " as integer. Ignoring entire line: " + line, new Object[0]);
                    continue;
                }
                catch (NullPointerException ex) {
                    ScalingHealth.logHelper.warn("Mob potion effects: potion \"" + id + "\" does not exist.", new Object[0]);
                    continue;
                }
                this.potionMap.put(potion, minDiff, level - 1);
                continue;
            }
            ScalingHealth.logHelper.warn("Mob potion effects: malformed line (need 3 comma-separated values): " + line + "Ignoring entire line.", new Object[0]);
        }
    }

    @SubscribeEvent
    public void onMobSpawn(LivingEvent.LivingUpdateEvent event) {
        if (this.process(event.getEntityLiving())) {
            ++this.debugMobsProcessed;
        }
    }

    private boolean process(EntityLivingBase entity) {
        if (!entity.field_70170_p.field_72995_K && !DifficultyHandler.isProcessed(entity) && entity instanceof EntityLiving) {
            boolean difficultyEnabled;
            boolean bl = difficultyEnabled = Config.Difficulty.maxValue > 0.0f;
            if (difficultyEnabled && DifficultyHandler.canIncreaseEntityHealth(entity) && !DifficultyHandler.entityBlacklistedFromHealthIncrease(entity)) {
                boolean makeBlight = this.increaseEntityHealth(entity);
                if (makeBlight && !BlightHandler.isBlight(entity)) {
                    this.makeEntityBlight((EntityLiving)entity, ScalingHealth.random);
                }
                return true;
            }
            if (!difficultyEnabled && !DifficultyHandler.entityBlacklistedFromBecomingBlight(entity)) {
                if (DifficultyHandler.isAlwaysBlight(entity)) {
                    this.makeEntityBlight((EntityLiving)entity, ScalingHealth.random);
                } else if (Config.Mob.Blight.fixedBlightChance && MathUtils.tryPercentage((double)Config.Mob.Blight.chanceMultiplier)) {
                    this.makeEntityBlight((EntityLiving)entity, ScalingHealth.random);
                }
                entity.getEntityData().func_74777_a(NBT_ENTITY_DIFFICULTY, (short)-1);
                return true;
            }
        }
        return false;
    }

    public boolean recalculate(EntityLivingBase entity) {
        AttributeHelper.remove((EntityLivingBase)entity, (IAttribute)SharedMonsterAttributes.field_111264_e, (UUID)ModifierHandler.MODIFIER_ID_DAMAGE);
        AttributeHelper.remove((EntityLivingBase)entity, (IAttribute)SharedMonsterAttributes.field_111267_a, (UUID)ModifierHandler.MODIFIER_ID_HEALTH);
        entity.getEntityData().func_74777_a(NBT_ENTITY_DIFFICULTY, (short)0);
        return this.process(entity);
    }

    private static boolean isProcessed(EntityLivingBase entity) {
        return entity.getEntityData().func_74765_d(NBT_ENTITY_DIFFICULTY) != 0;
    }

    private static boolean isAlwaysBlight(EntityLivingBase entity) {
        return Config.Mob.Blight.blightAlways && Config.Mob.Blight.blightAllList.matches((Entity)entity);
    }

    @SubscribeEvent
    public void onMobDeath(LivingDeathEvent event) {
        EntityLivingBase killed = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (source.func_76346_g() instanceof EntityPlayer) {
            EntityDifficultyChangeList.DifficultyChanges changes = Config.Difficulty.DIFFICULTY_PER_KILL_BY_MOB.get((Entity)killed);
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            SHPlayerDataHandler.PlayerData data = SHPlayerDataHandler.get(player);
            if (data != null) {
                float amount;
                boolean isBlight = BlightHandler.isBlight(killed);
                float f = amount = isBlight ? changes.onBlightKill : changes.onStandardKill;
                if (Config.Debug.debugMode) {
                    ScalingHealth.logHelper.info("Killed " + (isBlight ? "Blight " : "") + killed.func_70005_c_() + ": difficulty " + (amount > 0.0f ? "+" : "") + amount, new Object[0]);
                }
                data.incrementDifficulty(amount, true);
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (++this.serverTicks % 20 == 0 && Config.Debug.debugMode) {
            NetworkHandler.INSTANCE.sendToAll((IMessage)new MessageDebugData());
        }
    }

    public static int debugGetMobsProcessed() {
        return DifficultyHandler.INSTANCE.debugMobsProcessed;
    }

    public static float debugGetMobsProcessedRate() {
        return (float)DifficultyHandler.INSTANCE.debugMobsProcessed / ((float)DifficultyHandler.INSTANCE.serverTicks / 20.0f);
    }

    public static void debugHandleSyncMessage(MessageDebugData message) {
        DifficultyHandler.INSTANCE.debugMobsProcessed = message.mobsProcessed;
    }

    private boolean increaseEntityHealth(EntityLivingBase entityLiving) {
        MobPotionMap.PotionEntry pot;
        float potionChance;
        float difficulty;
        if (Config.Difficulty.maxValue <= 0.0f) {
            return false;
        }
        World world = entityLiving.field_70170_p;
        float originalDifficulty = difficulty = (float)Config.Difficulty.AREA_DIFFICULTY_MODE.getAreaDifficulty(world, entityLiving.func_180425_c());
        float originalMaxHealth = entityLiving.func_110138_aP();
        Random rand = ScalingHealth.random;
        boolean isHostile = entityLiving instanceof IMob;
        if (Config.Difficulty.DIFFICULTY_LUNAR_MULTIPLIERS_ENABLED && world.func_72820_D() % 24000L > 12000L) {
            int moonPhase = world.field_73011_w.func_76559_b(world.func_72820_D()) % 8;
            float multi = Config.Difficulty.DIFFICULTY_LUNAR_MULTIPLIERS[moonPhase];
            difficulty *= multi;
        }
        boolean makeBlight = false;
        if (!DifficultyHandler.entityBlacklistedFromBecomingBlight(entityLiving)) {
            float chance;
            float f = chance = Config.Mob.Blight.fixedBlightChance ? Config.Mob.Blight.chanceMultiplier : difficulty / Config.Difficulty.maxValue * Config.Mob.Blight.chanceMultiplier;
            if (DifficultyHandler.isAlwaysBlight(entityLiving) || rand.nextFloat() < chance) {
                makeBlight = true;
                difficulty *= Config.Mob.Blight.difficultyMultiplier;
            }
        }
        entityLiving.getEntityData().func_74777_a(NBT_ENTITY_DIFFICULTY, (short)difficulty);
        float totalDifficulty = difficulty;
        float genAddedHealth = difficulty;
        float baseMaxHealth = (float)entityLiving.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
        float healthMultiplier = isHostile ? Config.Mob.Health.hostileHealthMultiplier : Config.Mob.Health.peacefulHealthMultiplier;
        genAddedHealth *= healthMultiplier;
        if (Config.Difficulty.statsConsumeDifficulty) {
            difficulty -= genAddedHealth;
        }
        if (difficulty > 0.0f) {
            float diffIncrease = 2.0f * healthMultiplier * difficulty * rand.nextFloat();
            if (Config.Difficulty.statsConsumeDifficulty) {
                difficulty -= diffIncrease;
            }
            genAddedHealth += diffIncrease;
        }
        float genAddedDamage = 0.0f;
        if (difficulty > 0.0f && !Config.Mob.damageBonusBlacklist.contains((Entity)entityLiving)) {
            float diffIncrease = difficulty * rand.nextFloat();
            genAddedDamage = diffIncrease * Config.Mob.damageMultiplier;
            if (Config.Mob.maxDamageBoost > 0.0f) {
                genAddedDamage = MathHelper.func_76131_a((float)genAddedDamage, (float)0.0f, (float)Config.Mob.maxDamageBoost);
            }
            if (Config.Difficulty.statsConsumeDifficulty) {
                difficulty -= genAddedDamage / Config.Mob.damageMultiplier;
            }
        }
        float f = potionChance = isHostile ? Config.Mob.hostilePotionChance : Config.Mob.passivePotionChance;
        if (difficulty > 0.0f && rand.nextFloat() < potionChance && (pot = this.potionMap.getRandom(rand, (int)difficulty)) != null) {
            entityLiving.func_70690_d(new PotionEffect(pot.potion, POTION_APPLY_TIME));
        }
        float healthScaleDiff = Math.max(0.0f, baseMaxHealth - 20.0f);
        switch (Config.Mob.Health.healthScalingMode) {
            case ADD: {
                ModifierHandler.setMaxHealth(entityLiving, genAddedHealth + baseMaxHealth, 0);
                break;
            }
            case MULTI: {
                float healthMulti = genAddedHealth / 20.0f;
                ModifierHandler.setMaxHealth(entityLiving, healthMulti + baseMaxHealth, 1);
                break;
            }
            case MULTI_HALF: {
                float healthMulti = genAddedHealth / (20.0f + healthScaleDiff * 0.5f);
                ModifierHandler.setMaxHealth(entityLiving, healthMulti + baseMaxHealth, 1);
                break;
            }
            case MULTI_QUARTER: {
                float healthMulti = genAddedHealth / (20.0f + healthScaleDiff * 0.75f);
                ModifierHandler.setMaxHealth(entityLiving, healthMulti + baseMaxHealth, 1);
                break;
            }
            default: {
                ScalingHealth.logHelper.fatal("Unknown mob health scaling mode: " + Config.Mob.Health.healthScalingMode.name(), new Object[0]);
            }
        }
        ModifierHandler.addAttackDamage(entityLiving, genAddedDamage, 0);
        if (entityLiving.func_110138_aP() != originalMaxHealth) {
            entityLiving.func_70606_j(entityLiving.func_110138_aP());
        }
        if (Config.Debug.debugMode && Config.Debug.logSpawns && originalDifficulty > 0.0f) {
            BlockPos pos = entityLiving.func_180425_c();
            String line = "Spawn debug: %s (%d, %d, %d): Difficulty=%.2f, Health +%.2f, Damage +%.2f";
            line = String.format(line, entityLiving.func_70005_c_(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Float.valueOf(totalDifficulty), Float.valueOf(genAddedHealth), Float.valueOf(genAddedDamage));
            ScalingHealth.logHelper.info(line, new Object[0]);
        }
        return makeBlight;
    }

    private void makeEntityBlight(EntityLiving entityLiving, Random rand) {
        BlightSpawnEvent.Pre event = new BlightSpawnEvent.Pre(entityLiving, entityLiving.field_70170_p, (float)entityLiving.field_70165_t, (float)entityLiving.field_70163_u, (float)entityLiving.field_70161_v);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        BlightHandler.markBlight((EntityLivingBase)entityLiving, true);
        BlightHandler.spawnBlightFire((EntityLivingBase)entityLiving);
        BlightHandler.applyBlightPotionEffects((EntityLivingBase)entityLiving);
        int highestTier = 4;
        int commonTier = Config.BLIGHT_EQUIPMENT_HIGHEST_COMMON_TIER;
        int tier = rand.nextInt(1 + commonTier);
        for (int j = 0; j < 4 - commonTier; ++j) {
            if (!(rand.nextFloat() < Config.BLIGHT_EQUIPMENT_TIER_UP_CHANCE)) continue;
            ++tier;
        }
        tier = MathHelper.func_76125_a((int)tier, (int)0, (int)4);
        float pieceChance = Config.BLIGHT_EQUIPMENT_ARMOR_PIECE_CHANCE;
        for (EntityEquipmentSlot slot : this.ORDERED_SLOTS) {
            ItemStack newEquipment;
            ItemStack oldEquipment = entityLiving.func_184582_a(slot);
            if (slot != EntityEquipmentSlot.HEAD && rand.nextFloat() > pieceChance) break;
            if (!oldEquipment.func_190926_b() || (newEquipment = this.selectEquipmentForSlot(slot, tier)).func_190926_b()) continue;
            entityLiving.func_184201_a(slot, newEquipment);
        }
        pieceChance = Config.BLIGHT_EQUIPMENT_HAND_PIECE_CHANCE;
        if (rand.nextFloat() > pieceChance) {
            ItemStack newEquipment;
            ItemStack oldEquipment = entityLiving.func_184614_ca();
            if (oldEquipment.func_190926_b() && !(newEquipment = this.selectEquipmentForSlot(EntityEquipmentSlot.MAINHAND, tier)).func_190926_b()) {
                entityLiving.func_184201_a(EntityEquipmentSlot.MAINHAND, newEquipment);
            }
            if (rand.nextFloat() > pieceChance && (oldEquipment = entityLiving.func_184592_cb()).func_190926_b() && !(newEquipment = this.selectEquipmentForSlot(EntityEquipmentSlot.OFFHAND, tier)).func_190926_b()) {
                entityLiving.func_184201_a(EntityEquipmentSlot.OFFHAND, newEquipment);
            }
        }
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack = entityLiving.func_184582_a(slot);
            if (stack.func_190926_b() || stack.func_77948_v()) continue;
            EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)stack, (int)30, (boolean)false);
        }
        if (Config.Mob.Blight.superchargeCreepers && entityLiving instanceof EntityCreeper) {
            entityLiving.func_70077_a(new EntityLightningBolt(entityLiving.field_70170_p, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, true));
            entityLiving.func_70066_B();
            entityLiving.func_70691_i(5.0f);
        }
        MessageMarkBlight message = new MessageMarkBlight((EntityLivingBase)entityLiving, true);
        NetworkHandler.INSTANCE.sendToAllAround((IMessage)message, new NetworkRegistry.TargetPoint(entityLiving.field_71093_bK, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, 128.0));
        MinecraftForge.EVENT_BUS.post((Event)new BlightSpawnEvent.Post(entityLiving, entityLiving.field_70170_p, (float)entityLiving.field_70165_t, (float)entityLiving.field_70163_u, (float)entityLiving.field_70161_v));
    }

    private static boolean entityBlacklistedFromHealthIncrease(EntityLivingBase entityLiving) {
        boolean isPassive;
        if (entityLiving == null) {
            return true;
        }
        boolean isBoss = !entityLiving.func_184222_aU();
        boolean isHostile = entityLiving instanceof IMob;
        boolean bl = isPassive = !isHostile;
        if (isHostile && (Config.Mob.Health.hostileHealthMultiplier == 0.0f || !Config.Mob.Health.allowHostile) || isPassive && (Config.Mob.Health.peacefulHealthMultiplier == 0.0f || !Config.Mob.Health.allowPeaceful) || isBoss && (Config.Mob.Health.hostileHealthMultiplier == 0.0f || !Config.Mob.Health.allowBoss)) {
            return true;
        }
        EntityMatchList blacklist = Config.Mob.Health.mobBlacklist;
        List<Integer> dimBlacklist = Config.Mob.Health.dimensionBlacklist;
        if (blacklist == null || dimBlacklist == null) {
            return false;
        }
        return blacklist.contains((Entity)entityLiving) || dimBlacklist.contains(entityLiving.field_71093_bK);
    }

    private static boolean canIncreaseEntityHealth(EntityLivingBase entity) {
        if (entity == null || DifficultyHandler.isProcessed(entity) || !entity.field_70170_p.func_82736_K().func_82766_b("ScalingHealthDifficulty")) {
            return false;
        }
        AttributeModifier modifier = entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(ModifierHandler.MODIFIER_ID_HEALTH);
        return entity.field_70173_aa > 1 && (modifier == null || modifier.func_111164_d() == 0.0 || Double.isNaN(modifier.func_111164_d()));
    }

    private static boolean entityBlacklistedFromBecomingBlight(EntityLivingBase entityLiving) {
        if (entityLiving == null || BlightHandler.isBlight(entityLiving)) {
            return true;
        }
        EntityMatchList blacklist = Config.Mob.Blight.blacklist;
        boolean isBoss = !entityLiving.func_184222_aU();
        boolean isHostile = entityLiving instanceof IMob;
        boolean isPassive = !isHostile;
        return blacklist != null && (blacklist.contains((Entity)entityLiving) || isHostile && Config.Mob.Blight.blacklistHostiles || isPassive && Config.Mob.Blight.blacklistPassives || isBoss && Config.Mob.Blight.blacklistBosses);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world.func_82737_E() % 20L == 0L) {
            ScalingHealthSavedData data = ScalingHealthSavedData.get(event.world);
            data.difficulty += (double)Config.Difficulty.perSecond;
            data.func_76185_a();
        }
    }

    public void initDefaultEquipment() {
        this.mapHelmets.put(new ItemStack((Item)Items.field_151024_Q), 0);
        this.mapHelmets.put(new ItemStack((Item)Items.field_151169_ag), 1);
        this.mapHelmets.put(new ItemStack((Item)Items.field_151020_U), 2);
        this.mapHelmets.put(new ItemStack((Item)Items.field_151028_Y), 3);
        this.mapHelmets.put(new ItemStack((Item)Items.field_151161_ac), 4);
        this.mapChestplates.put(new ItemStack((Item)Items.field_151027_R), 0);
        this.mapChestplates.put(new ItemStack((Item)Items.field_151171_ah), 1);
        this.mapChestplates.put(new ItemStack((Item)Items.field_151023_V), 2);
        this.mapChestplates.put(new ItemStack((Item)Items.field_151030_Z), 3);
        this.mapChestplates.put(new ItemStack((Item)Items.field_151163_ad), 4);
        this.mapLeggings.put(new ItemStack((Item)Items.field_151026_S), 0);
        this.mapLeggings.put(new ItemStack((Item)Items.field_151149_ai), 1);
        this.mapLeggings.put(new ItemStack((Item)Items.field_151022_W), 2);
        this.mapLeggings.put(new ItemStack((Item)Items.field_151165_aa), 3);
        this.mapLeggings.put(new ItemStack((Item)Items.field_151173_ae), 4);
        this.mapBoots.put(new ItemStack((Item)Items.field_151021_T), 0);
        this.mapBoots.put(new ItemStack((Item)Items.field_151151_aj), 1);
        this.mapBoots.put(new ItemStack((Item)Items.field_151029_X), 2);
        this.mapBoots.put(new ItemStack((Item)Items.field_151167_ab), 3);
        this.mapBoots.put(new ItemStack((Item)Items.field_151175_af), 4);
    }

    private ItemStack selectEquipmentForSlot(EntityEquipmentSlot slot, int tier) {
        tier = MathHelper.func_76125_a((int)tier, (int)0, (int)4);
        switch (slot) {
            case CHEST: {
                return this.mapChestplates.getRandom(tier);
            }
            case FEET: {
                return this.mapBoots.getRandom(tier);
            }
            case HEAD: {
                return this.mapHelmets.getRandom(tier);
            }
            case LEGS: {
                return this.mapLeggings.getRandom(tier);
            }
            case MAINHAND: {
                return this.mapMainhands.getRandom(tier);
            }
            case OFFHAND: {
                return this.mapOffhands.getRandom(tier);
            }
        }
        return ItemStack.field_190927_a;
    }
}

