/*
 * Decompiled with CFR 0.152.
 */
package fermiumbooter.handler;

import fermiumbooter.config.FermiumBooterConfig;
import fermiumbooter.util.CustomLogger;
import fermiumbooter.util.FermiumJarScanner;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Mouse;

public abstract class CompatibilityWarningHandler {
    private static String warningMessage = null;
    private static int boxX;
    private static int boxY;
    private static int boxW;
    private static int boxH;

    @SubscribeEvent
    public static void render(TickEvent.RenderTickEvent event) {
        if (FermiumBooterConfig.suppressMixinCompatibilityWarningsRender) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        if (!(minecraft.field_71462_r instanceof GuiMainMenu)) {
            return;
        }
        int warningCount = FermiumJarScanner.getWarningCount();
        if (warningCount <= 0) {
            return;
        }
        if (warningMessage == null) {
            warningMessage = String.format("FermiumBooter found %d possible mixin compat errors, check your log or click here.", warningCount);
        }
        FontRenderer fontRenderer = minecraft.field_71466_p;
        boxX = fontRenderer.field_78288_b;
        boxY = fontRenderer.field_78288_b;
        boxW = fontRenderer.func_78256_a(warningMessage) + 4;
        boxH = boxY + 2;
        GlStateManager.func_179094_E();
        Gui.func_73734_a((int)boxX, (int)boxY, (int)(boxX + boxW), (int)(boxY + boxH), (int)Integer.MIN_VALUE);
        fontRenderer.func_78276_b(warningMessage, boxX + 2, boxY + 2, 0xFF5555);
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public static void onClick(GuiScreenEvent.MouseInputEvent.Pre event) {
        int mouseY;
        int mouseX;
        if (FermiumBooterConfig.suppressMixinCompatibilityWarningsRender) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71462_r instanceof GuiMainMenu)) {
            return;
        }
        int warningCount = FermiumJarScanner.getWarningCount();
        if (warningCount <= 0) {
            return;
        }
        if (Mouse.getEventButtonState() && Mouse.getEventButton() == 0 && CompatibilityWarningHandler.isMouseInsideBox(mouseX = Mouse.getEventX() * mc.field_71462_r.field_146294_l / mc.field_71443_c, mouseY = mc.field_71462_r.field_146295_m - Mouse.getEventY() * mc.field_71462_r.field_146295_m / mc.field_71440_d - 1)) {
            CompatibilityWarningHandler.openLogFile();
        }
    }

    private static boolean isMouseInsideBox(int x, int y) {
        return x >= boxX && x <= boxX + boxW && y >= boxY && y <= boxY + boxH;
    }

    private static void openLogFile() {
        File file = CustomLogger.LOG_PATH.toFile();
        if (!file.exists()) {
            return;
        }
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(file);
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
    }
}

