/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.mixinsquared.adjuster;

import com.bawnorton.mixinsquared.adjuster.MixinAnnotationAdjusterRegistrar;
import com.bawnorton.mixinsquared.adjuster.tools.AdjustableAnnotationNode;
import com.bawnorton.mixinsquared.adjuster.tools.type.RemappableAnnotationNode;
import com.bawnorton.mixinsquared.ext.MixinSquaredExtension;
import com.bawnorton.mixinsquared.reflection.MixinInfoExtension;
import com.bawnorton.mixinsquared.reflection.StateExtension;
import com.bawnorton.mixinsquared.reflection.TargetClassContextExtension;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import org.spongepowered.asm.service.MixinService;

@ApiStatus.Internal
public final class ExtensionAnnotationAdjust
implements IExtension,
MixinSquaredExtension {
    private static final ILogger LOGGER = MixinService.getService().getLogger("mixinsquared-annotation-adjuster");

    @Override
    public boolean checkActive(MixinEnvironment environment) {
        return true;
    }

    @Override
    public void preApply(ITargetClassContext context) {
        TargetClassContextExtension.tryAs(context, contextExtension -> {
            SortedSet<IMixinInfo> mixinInfos = contextExtension.getMixins();
            mixinInfos.forEach(mixinInfo -> MixinInfoExtension.tryAs(mixinInfo, mixinInfoExtension -> {
                ClassNode mixinClassNode = mixinInfo.getClassNode(0);
                List targetClassNames = mixinInfo.getTargetClasses().stream().map(s -> s.replaceAll("/", ".")).collect(Collectors.toList());
                String mixinClassName = mixinInfo.getClassName();
                List methodNodes = mixinClassNode.methods;
                methodNodes.forEach(methodNode -> {
                    List visibleAnnotations = methodNode.visibleAnnotations;
                    if (visibleAnnotations == null) {
                        return;
                    }
                    ArrayList<AdjustableAnnotationNode> postAdjust = new ArrayList<AdjustableAnnotationNode>();
                    for (AnnotationNode annotationNode : visibleAnnotations) {
                        AdjustableAnnotationNode postAdjusted;
                        AdjustableAnnotationNode preAdjusted = AdjustableAnnotationNode.fromNode(annotationNode);
                        AdjustableAnnotationNode initial = preAdjusted.copy();
                        if (preAdjusted instanceof RemappableAnnotationNode) {
                            RemappableAnnotationNode remappable = (RemappableAnnotationNode)((Object)preAdjusted);
                            remappable.setRemapper(node -> node.applyRefmap(mixinInfoExtension::remapClassName));
                        }
                        if ((postAdjusted = MixinAnnotationAdjusterRegistrar.adjust(targetClassNames, mixinClassName, methodNode, preAdjusted, (adjuster, node) -> {
                            LOGGER.warn("Modified mixin \"{}\". Check debug logs for more information.", mixinClassName);
                            LOGGER.debug("Adjuster \"{}\" modified annotation on method \"{}\" in mixin \"{}\"", adjuster, methodNode.name + methodNode.desc, mixinClassName);
                            LOGGER.debug("Pre-adjustment: {}", initial);
                            LOGGER.debug("Post-adjustment: {}", node == null ? "null" : node);
                        })) == null) continue;
                        postAdjust.add(postAdjusted);
                    }
                    visibleAnnotations.clear();
                    visibleAnnotations.addAll(postAdjust);
                });
                StateExtension.tryAs(mixinInfoExtension.getState(), stateExtension -> stateExtension.setClassNode(mixinClassNode));
            }));
        });
    }

    @Override
    public void postApply(ITargetClassContext context) {
    }

    @Override
    public void export(MixinEnvironment env, String name, boolean force, ClassNode classNode) {
    }
}

