/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings.builtin;

import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.TowerSettings;
import greymerk.roguelike.dungeon.towers.TowerType;
import greymerk.roguelike.theme.Theme;

public class BuiltinThemeSettings
extends DungeonSettings {
    public static final SettingIdentifier ID = new SettingIdentifier("builtin", "theme");
    private static final Theme[] themes = new Theme[]{Theme.OAK, Theme.SPRUCE, Theme.CRYPT, Theme.MOSSY};
    private static final Theme[] level4Themes = new Theme[]{Theme.CAVE, Theme.HELL, Theme.ICE, Theme.NETHER, Theme.NETHER_FORTRESS};

    public BuiltinThemeSettings() {
        super(ID);
        this.setTowerSettings(new TowerSettings(TowerType.ROGUE, Theme.TOWER));
        for (int level = 0; level < 5; ++level) {
            LevelSettings levelSettings = new LevelSettings(level);
            Theme theme = level == 4 ? this.randomTheme() : themes[level];
            levelSettings.setTheme(theme);
            this.getLevelSettings().put(level, levelSettings);
        }
    }

    private Theme randomTheme() {
        int choice = (int)(Math.random() * (double)level4Themes.length);
        return level4Themes[choice];
    }
}

