/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import com.github.fnar.forge.ModLoader;
import com.github.fnar.minecraft.block.spawner.Spawner;
import com.github.fnar.minecraft.block.spawner.SpawnerSettings;
import com.github.fnar.roguelike.settings.RequiredModMissingException;
import com.github.fnar.roguelike.settings.parsing.RequirementsParser;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.dungeon.base.RoomsSetting;
import greymerk.roguelike.dungeon.base.SecretsSetting;
import greymerk.roguelike.dungeon.layout.LayoutGenerator;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.rooms.RoomSettingParser;
import greymerk.roguelike.dungeon.segment.SegmentGenerator;
import greymerk.roguelike.dungeon.settings.DungeonSettingParseException;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.settings.SegmentsParser;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.SettingsType;
import greymerk.roguelike.dungeon.settings.TowerSettings;
import greymerk.roguelike.dungeon.settings.level.LevelsParser;
import greymerk.roguelike.dungeon.settings.parsing.spawncriteria.SpawnCriteriaParser;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.theme.ThemeParser;
import greymerk.roguelike.treasure.loot.LootRulesParser;
import greymerk.roguelike.treasure.loot.LootTableRule;
import greymerk.roguelike.worldgen.filter.Filter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class DungeonSettingsParser {
    public static final List<Integer> ALL_LEVELS = Collections.unmodifiableList(Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 4}));
    private final ModLoader modLoader;

    public DungeonSettingsParser(ModLoader modLoader) {
        this.modLoader = modLoader;
    }

    public Optional<DungeonSettings> parseJson(String content) throws Exception {
        try {
            JsonObject parse;
            JsonParser jsonParser = new JsonParser();
            try {
                parse = jsonParser.parse(content).getAsJsonObject();
            }
            catch (JsonSyntaxException e) {
                throw new Exception(e.getCause());
            }
            return this.parseDungeonSettings(parse);
        }
        catch (RequiredModMissingException | DungeonSettingParseException exception) {
            throw exception;
        }
        catch (Exception e) {
            throw new Exception("An unknown error occurred while parsing json: " + e.getClass() + " " + e.getMessage());
        }
    }

    public Optional<DungeonSettings> parseDungeonSettings(JsonObject root) throws Exception {
        List<String> requires = RequirementsParser.parse(root);
        if (!this.hasRequiredMods(requires)) {
            return Optional.empty();
        }
        DungeonSettings dungeonSettings = new DungeonSettings();
        for (int level = 0; level < 5; ++level) {
            LevelSettings setting = new LevelSettings(level);
            dungeonSettings.getLevelSettings().put(level, setting);
        }
        DungeonSettingsParser.parseId(root, dungeonSettings);
        DungeonSettingsParser.parseExclusive(root, dungeonSettings);
        DungeonSettingsParser.parseCriteria(root, dungeonSettings);
        DungeonSettingsParser.parseTower(root, dungeonSettings);
        DungeonSettingsParser.parseLootRules(root, dungeonSettings);
        DungeonSettingsParser.parseOverrides(root, dungeonSettings);
        DungeonSettingsParser.parseInherit(root, dungeonSettings);
        DungeonSettingsParser.parseLootTables(root, dungeonSettings);
        DungeonSettingsParser.parseRoomCount(root, dungeonSettings);
        DungeonSettingsParser.parseScatter(root, dungeonSettings);
        DungeonSettingsParser.parseLayouts(root, dungeonSettings);
        DungeonSettingsParser.parseSpawners(root, dungeonSettings);
        DungeonSettingsParser.parseRooms(root, dungeonSettings);
        DungeonSettingsParser.parseThemes(root, dungeonSettings);
        DungeonSettingsParser.parseSegments(root, dungeonSettings);
        DungeonSettingsParser.parseFilters(root, dungeonSettings);
        return Optional.of(dungeonSettings);
    }

    private boolean hasRequiredMods(List<String> requires) throws Exception {
        if (!RogueConfig.BREAK_IF_REQUIRED_MOD_IS_MISSING.getBoolean()) {
            return true;
        }
        Optional<RequiredModMissingException> modMissingException = requires.stream().filter(this::isModAbsent).map(RequiredModMissingException::new).findFirst();
        if (modMissingException.isPresent()) {
            throw modMissingException.get();
        }
        return true;
    }

    private boolean isModAbsent(String modName) {
        return !this.modLoader.isModLoaded(modName);
    }

    private static void parseId(JsonObject root, DungeonSettings dungeonSettings) throws Exception {
        if (!root.has("name")) {
            throw new Exception("Setting missing name");
        }
        if (root.has("namespace")) {
            String name = root.get("name").getAsString();
            String namespace = root.get("namespace").getAsString();
            dungeonSettings.setId(new SettingIdentifier(namespace, name));
        } else {
            dungeonSettings.setId(new SettingIdentifier(root.get("name").getAsString()));
        }
    }

    private static void parseExclusive(JsonObject root, DungeonSettings dungeonSettings) {
        if (root.has("exclusive")) {
            dungeonSettings.setExclusive(root.get("exclusive").getAsBoolean());
        }
    }

    private static void parseCriteria(JsonObject root, DungeonSettings dungeonSettings) {
        if (root.has("criteria")) {
            dungeonSettings.setSpawnCriteria(SpawnCriteriaParser.parse(root.get("criteria").getAsJsonObject()));
        }
    }

    private static void parseTower(JsonObject root, DungeonSettings dungeonSettings) throws Exception {
        if (root.has("tower")) {
            dungeonSettings.setTowerSettings(new TowerSettings(root.get("tower")));
        }
    }

    private static void parseLootRules(JsonObject root, DungeonSettings dungeonSettings) throws Exception {
        if (root.has("loot_rules")) {
            throw new DungeonSettingParseException("Please update field \"loot_rules\" to \"lootRules\" to conform to JSON standards.");
        }
        if (root.has("lootRules")) {
            dungeonSettings.getLootRules().addAll(new LootRulesParser().parseLootRules(root.get("lootRules")));
        }
    }

    private static void parseOverrides(JsonObject root, DungeonSettings dungeonSettings) {
        if (root.has("overrides")) {
            JsonArray overrides = root.get("overrides").getAsJsonArray();
            for (JsonElement jsonElement : overrides) {
                if (jsonElement.isJsonNull()) continue;
                dungeonSettings.getOverrides().add(SettingsType.valueOf(jsonElement.getAsString()));
            }
        }
    }

    private static void parseInherit(JsonObject root, DungeonSettings dungeonSettings) {
        if (root.has("inherit")) {
            JsonArray inherit = root.get("inherit").getAsJsonArray();
            for (JsonElement jsonElement : inherit) {
                if (jsonElement.isJsonNull()) continue;
                dungeonSettings.getInherit().add(new SettingIdentifier(jsonElement.getAsString()));
            }
        }
    }

    private static void parseLootTables(JsonObject root, DungeonSettings dungeonSettings) throws Exception {
        if (root.has("loot_tables")) {
            throw new DungeonSettingParseException("Please update field \"loot_tables\" to \"lootTables\" to conform to JSON standards.");
        }
        if (root.has("lootTables")) {
            JsonArray lootTables = root.get("lootTables").getAsJsonArray();
            for (JsonElement jsonElement : lootTables) {
                if (jsonElement.isJsonNull()) continue;
                dungeonSettings.getLootTables().add(new LootTableRule(jsonElement.getAsJsonObject()));
            }
        }
    }

    private static void parseRoomCount(JsonObject root, DungeonSettings dungeonSettings) {
        if (root.has("num_rooms")) {
            throw new DungeonSettingParseException("Please update field \"num_rooms\" to \"numRooms\" to conform to JSON standards.");
        }
        if (root.has("numRooms")) {
            JsonArray arr = root.get("numRooms").getAsJsonArray();
            for (int i = 0; i < arr.size(); ++i) {
                JsonElement jsonElement = arr.get(i);
                if (jsonElement.isJsonNull()) continue;
                LevelSettings setting = dungeonSettings.getLevelSettings().get(i);
                setting.setNumRooms(jsonElement.getAsInt());
            }
        }
    }

    private static void parseScatter(JsonObject root, DungeonSettings dungeonSettings) {
        if (root.has("scatter")) {
            JsonArray arr = root.get("scatter").getAsJsonArray();
            for (int i = 0; i < arr.size(); ++i) {
                JsonElement jsonElement = arr.get(i);
                if (jsonElement.isJsonNull()) continue;
                LevelSettings setting = dungeonSettings.getLevelSettings().get(i);
                setting.setScatter(jsonElement.getAsInt());
            }
        }
    }

    private static void parseLayouts(JsonObject root, DungeonSettings dungeonSettings) {
        if (!root.has("layouts")) {
            return;
        }
        JsonArray layouts = root.get("layouts").getAsJsonArray();
        for (JsonElement jsonElement : layouts) {
            JsonObject layout;
            if (jsonElement.isJsonNull() || !(layout = jsonElement.getAsJsonObject()).has("level")) continue;
            List<Integer> levels = LevelsParser.parseLevelsOrDefault(layout, ALL_LEVELS);
            for (Integer level : levels) {
                if (!dungeonSettings.getLevelSettings().containsKey(level)) continue;
                LevelSettings setting = dungeonSettings.getLevelSettings().get(level);
                setting.setGenerator(LayoutGenerator.Type.valueOf(layout.get("type").getAsString().toUpperCase()));
            }
        }
    }

    private static void parseRooms(JsonObject root, DungeonSettings dungeonSettings) {
        if (!root.has("rooms")) {
            return;
        }
        JsonArray roomArray = root.get("rooms").getAsJsonArray();
        for (int floorLevel : dungeonSettings.getLevelSettings().keySet()) {
            RoomsSetting roomsSetting = new RoomsSetting();
            SecretsSetting secretsSetting = new SecretsSetting();
            for (JsonElement roomSettingElement : roomArray) {
                JsonObject roomSettingJson;
                RoomSetting roomSetting;
                if (roomSettingElement.isJsonNull() || !(roomSetting = RoomSettingParser.parse(roomSettingJson = roomSettingElement.getAsJsonObject())).isOnFloorLevel(floorLevel)) continue;
                if (roomSetting.isSecret()) {
                    secretsSetting.add(roomSetting);
                    continue;
                }
                roomsSetting.add(roomSetting);
            }
            LevelSettings level = dungeonSettings.getLevelSettings().get(floorLevel);
            level.setRooms(roomsSetting);
            level.setSecrets(secretsSetting);
        }
    }

    private static void parseThemes(JsonObject rootJsonObject, DungeonSettings dungeonSettings) throws DungeonSettingParseException {
        if (!rootJsonObject.has("themes")) {
            return;
        }
        JsonElement themesJsonElement = rootJsonObject.get("themes");
        if (themesJsonElement.isJsonObject()) {
            throw new DungeonSettingParseException("Expected field 'themes' to be list of themes but instead found a single object.");
        }
        if (!themesJsonElement.isJsonArray()) {
            throw new DungeonSettingParseException("Expected field 'themes' to be list of themes but it wasn't.");
        }
        JsonArray themesJsonArray = themesJsonElement.getAsJsonArray();
        for (JsonElement themeJsonElement : themesJsonArray) {
            JsonObject themeJsonObject;
            List<Integer> levels;
            if (themeJsonElement.isJsonNull() || (levels = LevelsParser.parseLevelsOrDefault(themeJsonObject = themeJsonElement.getAsJsonObject(), ALL_LEVELS)) == null) continue;
            for (int level : levels) {
                if (!dungeonSettings.getLevelSettings().containsKey(level)) continue;
                LevelSettings settings = dungeonSettings.getLevelSettings().get(level);
                Theme theme = ThemeParser.parse(themeJsonObject);
                settings.setTheme(theme);
            }
        }
    }

    private static void parseSegments(JsonObject dungeonSettingsJson, DungeonSettings dungeonSettings) {
        if (dungeonSettingsJson.has("segments")) {
            JsonElement segmentsElement = dungeonSettingsJson.get("segments");
            SegmentsParser.parseSegments(segmentsElement).forEach((level, segments) -> dungeonSettings.getLevelSettings((int)level).getSegments().add((SegmentGenerator)segments));
        }
    }

    private static void parseSpawners(JsonObject root, DungeonSettings dungeonSettings) throws Exception {
        if (!root.has("spawners")) {
            return;
        }
        JsonArray spawnersJson = root.get("spawners").getAsJsonArray();
        for (JsonElement spawnerJsonElement : spawnersJson) {
            JsonObject spawnerJson = spawnerJsonElement.getAsJsonObject();
            List<Integer> levels = LevelsParser.parseLevelsOrDefault(spawnerJson, ALL_LEVELS);
            Spawner spawner = SpawnerSettings.parseSpawnPotentials(spawnerJson);
            int weight = SpawnerSettings.parseWeight(spawnerJson);
            levels.stream().mapToInt(level -> level).filter(level -> dungeonSettings.getLevelSettings().containsKey(level)).forEach(level -> dungeonSettings.getLevelSettings().get(level).getSpawnerSettings().add(spawner, weight));
        }
    }

    private static void parseFilters(JsonObject root, DungeonSettings dungeonSettings) {
        if (!root.has("filters")) {
            return;
        }
        JsonArray filtersArray = root.get("filters").getAsJsonArray();
        for (JsonElement filterElement : filtersArray) {
            JsonObject filterObject = filterElement.getAsJsonObject();
            List<Integer> levels = LevelsParser.parseLevelsOrDefault(filterObject, ALL_LEVELS);
            for (int level : levels) {
                if (!dungeonSettings.getLevelSettings().containsKey(level)) continue;
                String name = filterObject.get("name").getAsString();
                Filter type = Filter.valueOf(name.toUpperCase());
                dungeonSettings.getLevelSettings().get(level).addFilter(type);
            }
        }
    }

    private static List<RoomSetting> parseRoomSettings(JsonArray roomArray) {
        ArrayList roomSettings = Lists.newArrayList();
        for (JsonElement roomSettingElement : roomArray) {
            if (roomSettingElement.isJsonNull()) continue;
            JsonObject roomSettingJson = roomSettingElement.getAsJsonObject();
            roomSettings.add(RoomSettingParser.parse(roomSettingJson));
        }
        return roomSettings;
    }
}

