/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.config;

import greymerk.roguelike.config.Configuration;
import java.io.BufferedReader;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class INIParser {
    private static final Pattern LINE_PATTERN = Pattern.compile("^([^=]+)=(.*)$");
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^#");

    public static Configuration readLine(BufferedReader reader) throws Exception {
        String value;
        String key;
        Matcher matcher;
        String line;
        do {
            if ((line = reader.readLine()) != null) continue;
            return null;
        } while ((line = line.trim()).length() == 0 || COMMENT_PATTERN.matcher(line).find() || !(matcher = LINE_PATTERN.matcher(line)).find() || (key = matcher.group(1).trim()).length() == 0 || (value = matcher.group(2).trim()).length() == 0);
        return new Configuration(key, value);
    }

    public static void write(Configuration config, Writer writer) throws Exception {
        writer.write(config.key);
        writer.write("=");
        writer.write(config.value);
        writer.write(System.getProperty("line.separator"));
    }
}

