/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.roguelike.command;

import com.github.fnar.minecraft.WorldEditor1_12;
import com.github.fnar.minecraft.item.CouldNotMapItemException;
import com.github.fnar.minecraft.item.RldItemStack;
import com.github.fnar.minecraft.item.mapper.ItemMapper1_12;
import com.github.fnar.roguelike.Roguelike;
import com.github.fnar.roguelike.command.CommandSender;
import com.github.fnar.roguelike.command.TextFormattingMapper1_12;
import com.github.fnar.roguelike.command.message.ErrorMessage;
import com.github.fnar.roguelike.command.message.Message;
import com.github.fnar.roguelike.command.message.MessageType;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandSender1_12
implements CommandSender {
    private final ICommandSender commandSender;

    public CommandSender1_12(ICommandSender iCommandSender) {
        this.commandSender = iCommandSender;
    }

    @Override
    public void sendMessage(Message message) {
        TextComponentTranslation textComponent = new TextComponentTranslation(message.getMessage(), new Object[0]);
        textComponent = CommandSender1_12.withStyle((ITextComponent)textComponent, message.getMessageType());
        textComponent = message.getDetails() != null ? CommandSender1_12.withDetails(textComponent.func_150258_a(" "), message.getDetails()) : textComponent;
        this.commandSender.func_145747_a((ITextComponent)textComponent);
    }

    private static ITextComponent withDetails(ITextComponent component, String details) {
        return details != null ? component.func_150257_a((ITextComponent)new TextComponentString(details)) : component;
    }

    private static ITextComponent withStyle(ITextComponent textComponent, MessageType type) {
        Style style = new Style().func_150238_a(TextFormattingMapper1_12.map(type.getTextFormat().getCodeChar()));
        return textComponent.func_150255_a(style);
    }

    @Override
    public void give(RldItemStack item) {
        try {
            Entity player = this.commandSender.func_174793_f();
            ItemStack mappedItem = new ItemMapper1_12().map(item);
            EntityItem drop = player.func_70099_a(mappedItem, 0.0f);
            drop.func_174868_q();
        }
        catch (CouldNotMapItemException e) {
            Roguelike.LOGGER.info((Object)e);
            this.sendMessage(new ErrorMessage(e.getMessage()));
        }
    }

    @Override
    public WorldEditor createWorldEditor() {
        return new WorldEditor1_12(this.commandSender.func_130014_f_());
    }

    @Override
    public Coord getCoord() {
        BlockPos blockPos = this.commandSender.func_180425_c();
        return new Coord(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }
}

