/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft.tag;

import com.github.fnar.minecraft.tag.CompoundTag;
import com.github.fnar.minecraft.tag.ListTag;
import com.github.fnar.minecraft.tag.StringTag;
import com.github.fnar.minecraft.tag.Tag;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Set;

public class TagParser {
    public Tag parse(JsonElement jsonElement) {
        if (jsonElement.isJsonNull()) {
            return null;
        }
        if (jsonElement.isJsonArray()) {
            return this.parse(jsonElement.getAsJsonArray());
        }
        if (jsonElement.isJsonObject()) {
            return this.parse(jsonElement.getAsJsonObject());
        }
        if (jsonElement.isJsonPrimitive()) {
            return new StringTag(jsonElement.getAsString());
        }
        return null;
    }

    public CompoundTag parse(JsonObject jsonObject) {
        CompoundTag compoundTag = new CompoundTag();
        Set entries = jsonObject.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            compoundTag.withTag(key, this.parse(value));
        }
        return compoundTag;
    }

    public ListTag parse(JsonArray array) {
        ListTag listTag = new ListTag();
        for (int i = 0; i < array.size(); ++i) {
            listTag.withTags(this.parse(array.get(i)));
        }
        return listTag;
    }
}

