/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft.item.mapper;

import com.github.fnar.minecraft.item.CouldNotMapItemException;
import com.github.fnar.minecraft.item.Enchantment;
import com.github.fnar.minecraft.item.ItemMapper;
import com.github.fnar.minecraft.item.RldBaseItem;
import com.github.fnar.minecraft.item.RldItemStack;
import com.github.fnar.minecraft.item.mapper.EnchantmentMapper1_12;
import com.github.fnar.minecraft.tag.CompoundTag;
import com.github.fnar.minecraft.tag.TagMapper1_12;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public abstract class BaseItemMapper1_12<RldBaseItemClass extends RldBaseItem>
implements ItemMapper {
    private static final Random RAND = new Random(0L);
    private static final TagMapper1_12 tagMapper = new TagMapper1_12();
    private final EnchantmentMapper1_12 enchantmentMapper = new EnchantmentMapper1_12();

    private static void mapPlzNbt(RldItemStack rldItemStack, ItemStack itemStack) throws CouldNotMapItemException {
        if (!rldItemStack.isPlzNbt()) {
            return;
        }
        try {
            itemStack.func_77982_d(JsonToNBT.func_180713_a((String)rldItemStack.getPlzNbt()));
        }
        catch (NBTException e) {
            throw new CouldNotMapItemException(rldItemStack);
        }
    }

    private static void mergeTags(RldItemStack rldItemStack, ItemStack itemStack) {
        Optional.ofNullable(rldItemStack.getTags()).ifPresent(compoundTag -> Optional.ofNullable(itemStack.func_77978_p()).orElseGet(() -> BaseItemMapper1_12.ensureNbtTags(itemStack)).func_179237_a(tagMapper.map((CompoundTag)compoundTag)));
    }

    private static NBTTagCompound ensureNbtTags(ItemStack itemStack) {
        itemStack.func_77982_d(new NBTTagCompound());
        return itemStack.func_77978_p();
    }

    private static ItemStack enchantItem(Random rand, ItemStack item, int enchantLevel) {
        boolean isBook;
        if (item == null) {
            return null;
        }
        List enchants = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)item, (int)enchantLevel, (boolean)false);
        boolean bl = isBook = item.func_77973_b() == Items.field_151122_aG;
        if (isBook) {
            item = new ItemStack(Items.field_151134_bR);
            if (enchants.size() > 1) {
                enchants.remove(rand.nextInt(enchants.size()));
            }
        }
        for (EnchantmentData toAdd : enchants) {
            if (isBook) {
                ItemEnchantedBook.func_92115_a((ItemStack)item, (EnchantmentData)toAdd);
                continue;
            }
            item.func_77966_a(toAdd.field_76302_b, toAdd.field_76303_c);
        }
        return item;
    }

    public abstract Class<RldBaseItemClass> getClazz();

    @Override
    public ItemStack map(RldItemStack rldItemStack) throws CouldNotMapItemException {
        Class<RldBaseItemClass> clazz = this.getClazz();
        if (!clazz.isAssignableFrom(rldItemStack.getItem().getClass())) {
            throw new CouldNotMapItemException(rldItemStack);
        }
        ItemStack itemStack = this.map((RldBaseItem)this.getClazz().cast(rldItemStack.getItem()));
        itemStack.func_77964_b(rldItemStack.getDamage());
        itemStack.func_190920_e(rldItemStack.getCount());
        BaseItemMapper1_12.mapPlzNbt(rldItemStack, itemStack);
        BaseItemMapper1_12.mergeTags(rldItemStack, itemStack);
        return itemStack;
    }

    public abstract ItemStack map(RldBaseItemClass var1) throws CouldNotMapItemException;

    protected ItemStack addEnchantmentNbtTags(RldBaseItemClass rldItem, Item item) {
        return this.addEnchantmentNbtTags(rldItem, new ItemStack(item));
    }

    protected ItemStack addEnchantmentNbtTags(RldBaseItemClass rldItem, ItemStack itemStack) {
        if (((RldBaseItem)rldItem).isPlzEnchant()) {
            itemStack = BaseItemMapper1_12.enchantItem(RAND, itemStack, ((RldBaseItem)rldItem).getPlzEnchantLevel());
        }
        ItemStack finalItemStack = itemStack;
        ((RldBaseItem)rldItem).getEnchantments().forEach(enchantment -> finalItemStack.func_77966_a(this.enchantmentMapper.map((Enchantment)enchantment), enchantment.getLevel()));
        return finalItemStack;
    }
}

