/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft.block.redstone;

import com.github.fnar.minecraft.block.BlockType;
import com.github.fnar.minecraft.block.SingleBlockBrush;

public class ComparatorBlock
extends SingleBlockBrush {
    private Mode mode = Mode.COMPARE;
    private boolean isPowered;

    public ComparatorBlock() {
        super(BlockType.COMPARATOR);
    }

    public ComparatorBlock setMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isInCompareMode() {
        return this.getMode() == Mode.COMPARE;
    }

    public boolean isInSubtractMode() {
        return this.getMode() == Mode.SUBTRACTION;
    }

    public ComparatorBlock setPowered(boolean isPowered) {
        this.isPowered = isPowered;
        return this;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public static ComparatorBlock comparator() {
        return new ComparatorBlock();
    }

    @Override
    public ComparatorBlock copy() {
        ComparatorBlock copy = new ComparatorBlock();
        copy.setFacing(this.getFacing());
        copy.setMode(this.mode);
        copy.setPowered(this.isPowered);
        return copy;
    }

    public static enum Mode {
        COMPARE,
        SUBTRACTION;

    }
}

