/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft.block;

import com.github.fnar.minecraft.material.Wood;
import greymerk.roguelike.worldgen.Direction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;

public class WoodMapper1_12 {
    public static IBlockState mapLogs(Wood type, Direction facing) {
        Block block = WoodMapper1_12.mapLogBlock(type);
        return block.func_176223_P().func_177226_a(WoodMapper1_12.mapLogVariantProperty(type), (Comparable)WoodMapper1_12.getWoodVariant(type)).func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)WoodMapper1_12.mapLogFacing(facing));
    }

    private static BlockLog.EnumAxis mapLogFacing(Direction facing) {
        switch (facing) {
            case UP: 
            case DOWN: {
                return BlockLog.EnumAxis.Y;
            }
            case EAST: 
            case WEST: {
                return BlockLog.EnumAxis.X;
            }
            case NORTH: 
            case SOUTH: {
                return BlockLog.EnumAxis.Z;
            }
        }
        return BlockLog.EnumAxis.NONE;
    }

    private static Block mapLogBlock(Wood type) {
        switch (type) {
            default: {
                return Blocks.field_150364_r;
            }
            case ACACIA: 
            case DARK_OAK: 
        }
        return Blocks.field_150363_s;
    }

    private static PropertyEnum<BlockPlanks.EnumType> mapLogVariantProperty(Wood wood) {
        switch (wood) {
            default: {
                return BlockOldLog.field_176301_b;
            }
            case ACACIA: 
            case DARK_OAK: 
        }
        return BlockNewLog.field_176300_b;
    }

    public static IBlockState mapPlanks(Wood type) {
        return Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)WoodMapper1_12.getWoodVariant(type));
    }

    public static IBlockState mapLeaves(Wood type) {
        Block base = WoodMapper1_12.getLeavesBlock(type);
        return base.func_176223_P().func_177226_a(WoodMapper1_12.getLeavesVariantProperty(base), (Comparable)WoodMapper1_12.getWoodVariant(type)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
    }

    private static Block getLeavesBlock(Wood type) {
        switch (type) {
            case OAK: 
            case JUNGLE: 
            case BIRCH: 
            case SPRUCE: {
                return Blocks.field_150362_t;
            }
            case ACACIA: 
            case DARK_OAK: {
                return Blocks.field_150361_u;
            }
        }
        return Blocks.field_150364_r;
    }

    private static BlockPlanks.EnumType getWoodVariant(Wood type) {
        switch (type) {
            default: {
                return BlockPlanks.EnumType.OAK;
            }
            case SPRUCE: {
                return BlockPlanks.EnumType.SPRUCE;
            }
            case BIRCH: {
                return BlockPlanks.EnumType.BIRCH;
            }
            case JUNGLE: {
                return BlockPlanks.EnumType.JUNGLE;
            }
            case ACACIA: {
                return BlockPlanks.EnumType.ACACIA;
            }
            case DARK_OAK: 
        }
        return BlockPlanks.EnumType.DARK_OAK;
    }

    private static PropertyEnum<BlockPlanks.EnumType> getLeavesVariantProperty(Block base) {
        return base == Blocks.field_150362_t ? BlockOldLeaf.field_176239_P : BlockNewLeaf.field_176240_P;
    }

    public static IBlockState mapSapling(Wood type) {
        return Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)WoodMapper1_12.mapSaplingType(type));
    }

    private static BlockPlanks.EnumType mapSaplingType(Wood type) {
        switch (type) {
            default: {
                return BlockPlanks.EnumType.OAK;
            }
            case SPRUCE: {
                return BlockPlanks.EnumType.SPRUCE;
            }
            case BIRCH: {
                return BlockPlanks.EnumType.BIRCH;
            }
            case JUNGLE: {
                return BlockPlanks.EnumType.JUNGLE;
            }
            case ACACIA: {
                return BlockPlanks.EnumType.ACACIA;
            }
            case DARK_OAK: 
        }
        return BlockPlanks.EnumType.DARK_OAK;
    }
}

