/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft.block;

import com.github.fnar.minecraft.block.BlockType;
import com.github.fnar.minecraft.block.normal.ColoredBlock;
import greymerk.roguelike.util.DyeColor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;

public class ColoredBlockMapper1_12 {
    public static IBlockState getColoredBlock(ColoredBlock coloredBlock) {
        if (coloredBlock.getBlockType() == BlockType.TERRACOTTA) {
            return ColoredBlockMapper1_12.getTerracottaByColor(coloredBlock.getColor()).func_176223_P();
        }
        return ColoredBlockMapper1_12.getBlock(coloredBlock.getBlockType()).func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)ColoredBlockMapper1_12.toEnumDyeColor(coloredBlock.getColor()));
    }

    private static Block getBlock(BlockType type) {
        switch (type) {
            case STAINED_HARDENED_CLAY: {
                return Blocks.field_150406_ce;
            }
            case CARPET: {
                return Blocks.field_150404_cg;
            }
            case STAINED_GLASS: {
                return Blocks.field_150399_cn;
            }
            case STAINED_GLASS_PANE: {
                return Blocks.field_150397_co;
            }
            case CONCRETE: {
                return Blocks.field_192443_dR;
            }
            case CONCRETE_POWDER: {
                return Blocks.field_192444_dS;
            }
        }
        return Blocks.field_150325_L;
    }

    private static Block getTerracottaByColor(DyeColor color) {
        switch (color) {
            case WHITE: {
                return Blocks.field_192427_dB;
            }
            case ORANGE: {
                return Blocks.field_192428_dC;
            }
            case MAGENTA: {
                return Blocks.field_192429_dD;
            }
            case LIGHT_BLUE: {
                return Blocks.field_192430_dE;
            }
            case YELLOW: {
                return Blocks.field_192431_dF;
            }
            case LIME: {
                return Blocks.field_192432_dG;
            }
            case PINK: {
                return Blocks.field_192433_dH;
            }
            case GRAY: {
                return Blocks.field_192434_dI;
            }
            case LIGHT_GRAY: {
                return Blocks.field_192435_dJ;
            }
            case CYAN: {
                return Blocks.field_192436_dK;
            }
            case PURPLE: {
                return Blocks.field_192437_dL;
            }
            case BLUE: {
                return Blocks.field_192438_dM;
            }
            case BROWN: {
                return Blocks.field_192439_dN;
            }
            case GREEN: {
                return Blocks.field_192440_dO;
            }
            case RED: {
                return Blocks.field_192441_dP;
            }
        }
        return Blocks.field_192442_dQ;
    }

    public static EnumDyeColor toEnumDyeColor(DyeColor color) {
        try {
            return EnumDyeColor.valueOf((String)color.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return EnumDyeColor.WHITE;
        }
    }
}

