/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft;

import com.github.fnar.forge.ModLoader;
import com.github.fnar.forge.ModLoader1_12;
import com.github.fnar.minecraft.block.BlockMapper1_12;
import com.github.fnar.minecraft.block.BlockType;
import com.github.fnar.minecraft.block.ColoredBlockMapper1_12;
import com.github.fnar.minecraft.block.CouldNotMapBlockException;
import com.github.fnar.minecraft.block.DirectionMapper1_12;
import com.github.fnar.minecraft.block.Material;
import com.github.fnar.minecraft.block.SingleBlockBrush;
import com.github.fnar.minecraft.block.decorative.BedBlock;
import com.github.fnar.minecraft.block.decorative.PlantType;
import com.github.fnar.minecraft.block.decorative.Skull;
import com.github.fnar.minecraft.block.spawner.SpawnPotentialMapper1_12;
import com.github.fnar.minecraft.block.spawner.Spawner;
import com.github.fnar.minecraft.item.CouldNotMapItemException;
import com.github.fnar.minecraft.item.Plant;
import com.github.fnar.minecraft.item.RldItemStack;
import com.github.fnar.minecraft.item.mapper.ItemMapper1_12;
import com.github.fnar.minecraft.item.mapper.PlantMapper1_12;
import com.github.fnar.minecraft.world.BiomeTag;
import com.github.fnar.minecraft.world.BiomeTagMapper1_12;
import com.github.fnar.minecraft.world.BlockPosMapper1_12;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.treasure.TreasureManager;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.VanillaStructure;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBed;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldEditor1_12
implements WorldEditor {
    private static final Logger logger = LogManager.getLogger((String)"roguelike");
    private static final Set<net.minecraft.block.material.Material> validGroundBlocks = Sets.newHashSet((Object[])new net.minecraft.block.material.Material[]{net.minecraft.block.material.Material.field_151577_b, net.minecraft.block.material.Material.field_151578_c, net.minecraft.block.material.Material.field_151576_e, net.minecraft.block.material.Material.field_151595_p, net.minecraft.block.material.Material.field_151588_w, net.minecraft.block.material.Material.field_151598_x, net.minecraft.block.material.Material.field_151597_y, net.minecraft.block.material.Material.field_151571_B});
    private static final ModLoader modLoader = new ModLoader1_12();
    private final World world;
    private final Map<BlockType, Integer> stats = new HashMap<BlockType, Integer>();
    private final Random random;
    private final TreasureManager treasureManager;

    public WorldEditor1_12(World world) {
        this.world = world;
        this.random = new Random(Objects.hash(this.getSeed()));
        this.treasureManager = new TreasureManager(this.random);
    }

    public static void setSkullType(TileEntitySkull skull, Skull type) {
        skull.func_152107_a(WorldEditor1_12.getSkullId(type));
    }

    public static void setSkullRotation(Random rand, TileEntitySkull skull, Direction dir) {
        int directionValue = WorldEditor1_12.getDirectionValue(dir);
        directionValue += -1 + rand.nextInt(3);
        skull.func_145903_a(directionValue %= 16);
    }

    public static int getSkullId(Skull type) {
        switch (type) {
            default: {
                return 0;
            }
            case WITHER: {
                return 1;
            }
            case ZOMBIE: {
                return 2;
            }
            case STEVE: {
                return 3;
            }
            case CREEPER: 
        }
        return 4;
    }

    public static int getDirectionValue(Direction dir) {
        switch (dir) {
            default: {
                return 0;
            }
            case EAST: {
                return 4;
            }
            case SOUTH: {
                return 8;
            }
            case WEST: 
        }
        return 12;
    }

    @Override
    public void setSkull(WorldEditor editor, Coord cursor, Direction dir, Skull type) {
        SingleBlockBrush skullBlock = BlockType.SKELETONS_SKULL.getBrush();
        skullBlock.setFacing(Direction.UP);
        if (!skullBlock.stroke(editor, cursor)) {
            return;
        }
        TileEntity tileEntity = this.getTileEntity(cursor);
        if (tileEntity == null) {
            return;
        }
        if (!(tileEntity instanceof TileEntitySkull)) {
            return;
        }
        TileEntitySkull tileEntitySkull = (TileEntitySkull)tileEntity;
        WorldEditor1_12.setSkullType(tileEntitySkull, type);
        WorldEditor1_12.setSkullRotation(editor.getRandom(), tileEntitySkull, dir);
    }

    @Override
    public boolean isSolidBlock(Coord coord) {
        return this.getBlockStateAt(coord).func_185904_a().func_76220_a();
    }

    private IBlockState getBlockStateAt(Coord coord) {
        return this.world.func_180495_p(BlockPosMapper1_12.map(coord));
    }

    @Override
    public boolean isOpaqueBlock(Coord coord) {
        return this.getBlockStateAt(coord).func_185904_a().func_76218_k();
    }

    @Override
    public boolean isOpaqueCubeBlock(Coord coord) {
        return this.getBlockStateAt(coord).func_185914_p();
    }

    @Override
    public boolean isBlockOfTypeAt(BlockType blockType, Coord coord) {
        try {
            return BlockMapper1_12.map(blockType.getBrush()).func_177230_c() == this.getBlockStateAt(coord).func_177230_c();
        }
        catch (CouldNotMapBlockException e) {
            logger.info((Object)e);
            return false;
        }
    }

    @Override
    public boolean isMaterialAt(Material material, Coord coord) {
        throw new NotImplementedException("Bad Fnar, bad!");
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    @Override
    public Random getRandom(Coord coord) {
        this.random.setSeed(this.getSeed(coord));
        return this.random;
    }

    @Override
    public boolean setBlock(Coord coord, SingleBlockBrush singleBlockBrush, boolean fillAir, boolean replaceSolid) {
        IBlockState state;
        if (this.cantReplaceBlock(coord, fillAir, replaceSolid)) {
            return false;
        }
        try {
            state = BlockMapper1_12.map(singleBlockBrush);
        }
        catch (CouldNotMapBlockException e) {
            logger.info((Object)e);
            return false;
        }
        this.world.func_180501_a(BlockPosMapper1_12.map(coord), state, 2);
        this.setColorIfBed(coord, singleBlockBrush);
        BlockType blockType = singleBlockBrush.getBlockType();
        if (blockType != null) {
            this.stats.merge(blockType, 1, Integer::sum);
        }
        return true;
    }

    private boolean cantReplaceBlock(Coord coord, boolean fillAir, boolean replaceSolid) {
        return this.isIrreplaceableBlock(coord) || this.cantReplaceAir(coord, fillAir) || this.cantReplaceSolids(coord, replaceSolid);
    }

    private boolean isIrreplaceableBlock(Coord coord) {
        return this.blocksToNotReplace().stream().anyMatch(blockType -> this.isBlockOfTypeAt((BlockType)((Object)blockType), coord));
    }

    private List<BlockType> blocksToNotReplace() {
        return Lists.newArrayList((Object[])new BlockType[]{BlockType.BED, BlockType.BEDROCK, BlockType.CHEST, BlockType.END_PORTAL, BlockType.END_PORTAL_FRAME, BlockType.SPAWNER, BlockType.TRAPPED_CHEST});
    }

    private boolean cantReplaceAir(Coord coord, boolean fillAir) {
        return !fillAir && this.isAirBlock(coord);
    }

    private boolean cantReplaceSolids(Coord coord, boolean replaceSolid) {
        return !replaceSolid && this.isSolidBlock(coord);
    }

    @Override
    public boolean isAirBlock(Coord coord) {
        return this.world.func_175623_d(BlockPosMapper1_12.map(coord));
    }

    @Override
    public long getSeed() {
        return this.world.func_72905_C();
    }

    @Override
    public void fillDown(Coord origin, BlockBrush blocks) {
        Coord cursor = origin.copy();
        while (!this.isOpaqueCubeBlock(cursor) && cursor.getY() > 1) {
            blocks.stroke(this, cursor);
            cursor.down();
        }
    }

    public TileEntity getTileEntity(Coord pos) {
        return this.world.func_175625_s(BlockPosMapper1_12.map(pos));
    }

    @Override
    public boolean isValidGroundBlock(Coord coord) {
        return validGroundBlocks.contains(this.getBlockStateAt(coord).func_185904_a());
    }

    @Override
    public Map<BlockType, Integer> getStats() {
        return this.stats;
    }

    @Override
    public boolean isValidPosition(SingleBlockBrush block, Coord coord) {
        try {
            return BlockMapper1_12.map(block).func_177230_c().func_176198_a(this.world, BlockPosMapper1_12.map(coord), DirectionMapper1_12.map(block.getFacing()));
        }
        catch (CouldNotMapBlockException e) {
            logger.info((Object)e);
            return false;
        }
    }

    @Override
    public Coord findNearestStructure(VanillaStructure type, Coord coord, int radius) {
        ChunkProviderServer chunkProvider = ((WorldServer)this.world).func_72863_F();
        String structureName = VanillaStructure.getName(type);
        BlockPos structureBlockPosition = chunkProvider.func_180513_a(this.world, structureName, BlockPosMapper1_12.map(coord), false);
        return Optional.ofNullable(structureBlockPosition).map(BlockPosMapper1_12::map).orElse(null);
    }

    private void setColorIfBed(Coord coord, SingleBlockBrush singleBlockBrush) {
        TileEntity tileEntity = this.getTileEntity(coord);
        if (!singleBlockBrush.isBlockOfType(BlockType.BED)) {
            return;
        }
        if (!(tileEntity instanceof TileEntityBed) || !(singleBlockBrush instanceof BedBlock)) {
            logger.error("Failed to paint bed at position {}. Current block at position is {}.", (Object)coord, (Object)this.getBlockStateAt(coord));
            return;
        }
        ((TileEntityBed)tileEntity).func_193052_a(ColoredBlockMapper1_12.toEnumDyeColor(((BedBlock)singleBlockBrush).getColor()));
    }

    @Override
    public void setItem(Coord coord, int slot, RldItemStack itemStack) {
        TileEntity tileEntity = this.getTileEntity(coord);
        if (tileEntity == null) {
            return;
        }
        if (!(tileEntity instanceof TileEntityLockableLoot)) {
            return;
        }
        ItemStack forgeItemStack = null;
        try {
            forgeItemStack = new ItemMapper1_12().map(itemStack);
        }
        catch (CouldNotMapItemException e) {
            logger.error((Object)e);
        }
        try {
            ((TileEntityLockableLoot)tileEntity).func_70299_a(slot, forgeItemStack);
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Could not place item {} at position {}. BlockState at pos: {}.", (Object)forgeItemStack, (Object)coord, (Object)this.getBlockStateAt(coord));
        }
    }

    @Override
    public void setFlowerPotContent(Coord coord, PlantType choice) {
        TileEntity potEntity = this.getTileEntity(coord);
        if (potEntity == null) {
            return;
        }
        if (!(potEntity instanceof TileEntityFlowerPot)) {
            return;
        }
        TileEntityFlowerPot flowerPot = (TileEntityFlowerPot)potEntity;
        try {
            ItemStack flowerItem = new PlantMapper1_12().map(new Plant(choice));
            flowerPot.func_190614_a(flowerItem);
        }
        catch (CouldNotMapItemException e) {
            logger.error((Object)e);
        }
    }

    @Override
    public void setLootTable(Coord coord, String table) {
        ((TileEntityChest)this.getTileEntity(coord)).func_189404_a(new ResourceLocation(table), (long)this.getSeed(coord));
    }

    @Override
    public int getCapacity(TreasureChest treasureChest) {
        TileEntity tileEntity = this.getTileEntity(treasureChest.getCoord());
        if (!(tileEntity instanceof TileEntityLockableLoot)) {
            return 0;
        }
        return ((TileEntityLockableLoot)tileEntity).func_70302_i_();
    }

    @Override
    public boolean isEmptySlot(TreasureChest treasureChest, int slot) {
        return ((TileEntityLockableLoot)this.getTileEntity(treasureChest.getCoord())).func_70301_a(slot).func_190926_b();
    }

    @Override
    public void generateSpawner(Spawner spawner, Coord cursor) {
        Coord pos = cursor.copy();
        spawner.stroke(this, pos);
        TileEntity tileentity = this.getTileEntity(pos);
        if (!(tileentity instanceof TileEntityMobSpawner)) {
            return;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("x", pos.getX());
        nbt.func_74768_a("y", pos.getY());
        nbt.func_74768_a("z", pos.getZ());
        nbt.func_74782_a("SpawnPotentials", (NBTBase)SpawnPotentialMapper1_12.mapToNbt(spawner.getPotentials(), this.getRandom(), Dungeon.getLevel(pos.getY())));
        TileEntityMobSpawner tileEntity = (TileEntityMobSpawner)tileentity;
        MobSpawnerBaseLogic spawnerLogic = tileEntity.func_145881_a();
        spawnerLogic.func_98270_a(nbt);
        spawnerLogic.func_98278_g();
        tileentity.func_70296_d();
    }

    @Override
    public TreasureManager getTreasureManager() {
        return this.treasureManager;
    }

    @Override
    public int getDimension() {
        return this.world.field_73011_w.getDimension();
    }

    @Override
    public boolean isBiomeTypeAt(BiomeTag biomeTag, Coord coord) {
        return BiomeDictionary.hasType((Biome)this.getBiomeAt(coord), (BiomeDictionary.Type)BiomeTagMapper1_12.toBiomeDictionaryType(biomeTag));
    }

    @Override
    public String getBiomeName(Coord coord) {
        ResourceLocation registryName = this.getBiomeAt(coord).getRegistryName();
        if (Optional.ofNullable(registryName).isPresent()) {
            return registryName.toString();
        }
        return "";
    }

    @Override
    public List<String> getBiomeTagNames(Coord pos) {
        return BiomeDictionary.getTypes((Biome)this.getBiomeAt(pos)).stream().map(type -> type.getName() + " ").collect(Collectors.toList());
    }

    @Override
    public ModLoader getModLoader() {
        return modLoader;
    }

    public Biome getBiomeAt(Coord coord) {
        return this.world.func_180494_b(BlockPosMapper1_12.map(coord));
    }

    public String toString() {
        return this.stats.entrySet().stream().map(pair -> ((BlockType)((Object)((Object)pair.getKey()))).toString() + ": " + pair.getValue() + "\n").collect(Collectors.joining());
    }
}

