/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import me.lucko.spark.common.platform.world.AbstractChunkInfo;
import me.lucko.spark.common.platform.world.CountMap;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;

public abstract class ForgeWorldInfoProvider
implements WorldInfoProvider {
    protected List<ForgeChunkInfo> getChunksFromCache(ChunkProviderServer provider) {
        LongSet loadedChunks = provider.field_73244_f.keySet();
        ArrayList<ForgeChunkInfo> list = new ArrayList<ForgeChunkInfo>(loadedChunks.size());
        LongIterator iterator = loadedChunks.iterator();
        while (iterator.hasNext()) {
            long chunk = iterator.nextLong();
            ClassInheritanceMultiMap[] sections = ((Chunk)provider.field_73244_f.get(chunk)).func_177429_s();
            ChunkPos pos = ((Chunk)provider.field_73244_f.get(chunk)).func_76632_l();
            list.add(new ForgeChunkInfo(pos, sections));
        }
        return list;
    }

    static final class ForgeChunkInfo
    extends AbstractChunkInfo<Entity> {
        private final CountMap<Entity> entityCounts = new CountMap.Simple(new HashMap());

        ForgeChunkInfo(ChunkPos chunkPos, ClassInheritanceMultiMap<Entity>[] entities) {
            super(chunkPos.field_77276_a, chunkPos.field_77275_b);
            for (ClassInheritanceMultiMap<Entity> map : entities) {
                map.forEach(this.entityCounts::increment);
            }
        }

        @Override
        public CountMap<Entity> getEntityCounts() {
            return this.entityCounts;
        }

        @Override
        public String entityTypeName(Entity type) {
            return ForgeChunkInfo.nonNullName(EntityList.func_191301_a((Entity)type), type);
        }

        private static String nonNullName(ResourceLocation res, Entity ent) {
            return res != null ? res.toString() : ent.getClass().getName();
        }
    }

    public static final class Client
    extends ForgeWorldInfoProvider {
        private final Minecraft client;

        public Client(Minecraft client) {
            this.client = client;
        }

        @Override
        public WorldInfoProvider.CountsResult pollCounts() {
            WorldClient level = this.client.field_71441_e;
            if (level == null) {
                return null;
            }
            int entities = level.field_72996_f.size();
            int chunks = 0;
            return new WorldInfoProvider.CountsResult(-1, entities, -1, chunks);
        }

        public WorldInfoProvider.ChunksResult<ForgeChunkInfo> pollChunks() {
            WorldInfoProvider.ChunksResult<ForgeChunkInfo> data = new WorldInfoProvider.ChunksResult<ForgeChunkInfo>();
            return data;
        }

        @Override
        public WorldInfoProvider.GameRulesResult pollGameRules() {
            return null;
        }

        @Override
        public Collection<WorldInfoProvider.DataPackInfo> pollDataPacks() {
            return null;
        }
    }

    public static final class Server
    extends ForgeWorldInfoProvider {
        private final MinecraftServer server;

        public Server(MinecraftServer server) {
            this.server = server;
        }

        @Override
        public WorldInfoProvider.CountsResult pollCounts() {
            int players = this.server.func_71233_x();
            int entities = 0;
            int chunks = 0;
            for (WorldServer level : this.server.field_71305_c) {
                entities += level.field_72996_f.size();
                chunks += level.func_72863_F().func_73152_e();
            }
            return new WorldInfoProvider.CountsResult(players, entities, -1, chunks);
        }

        public WorldInfoProvider.ChunksResult<ForgeChunkInfo> pollChunks() {
            WorldInfoProvider.ChunksResult<ForgeChunkInfo> data = new WorldInfoProvider.ChunksResult<ForgeChunkInfo>();
            for (WorldServer level : this.server.field_71305_c) {
                List<ForgeChunkInfo> list = this.getChunksFromCache(level.func_72863_F());
                data.put(level.field_73011_w.func_186058_p().func_186065_b(), list);
            }
            return data;
        }

        @Override
        public WorldInfoProvider.GameRulesResult pollGameRules() {
            return null;
        }

        @Override
        public Collection<WorldInfoProvider.DataPackInfo> pollDataPacks() {
            return null;
        }
    }
}

