/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.logging.Level;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.SparkPlugin;
import me.lucko.spark.common.command.modules.SamplerModule;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.sampler.AbstractSampler;
import me.lucko.spark.common.sampler.Sampler;
import me.lucko.spark.common.sampler.SamplerMode;
import me.lucko.spark.common.sampler.SamplerSettings;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.sampler.ThreadGrouper;
import me.lucko.spark.common.sampler.async.AsyncProfilerAccess;
import me.lucko.spark.common.sampler.async.AsyncSampler;
import me.lucko.spark.common.sampler.async.SampleCollector;
import me.lucko.spark.common.sampler.java.JavaSampler;
import me.lucko.spark.common.sampler.java.MergeStrategy;
import me.lucko.spark.common.sampler.source.ClassSourceLookup;
import me.lucko.spark.forge.mixin.StateEnum;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;

public class ForgeLoadingSamplerModule {
    private static final String OPTION_ENGINE = "loadingProfiler_Option_Engine";
    private static final String OPTION_INTERVAL = "loadingProfiler_Option_Interval";
    private static final String OPTION_IGNORE_SLEEPING = "loadingProfiler_Option_IgnoreSleeping";
    private static final String OPTION_IGNORE_NATIVE = "loadingProfiler_Option_IgnoreNative";
    private static final String OPTION_THREAD_GROUPER = "loadingProfiler_Option_ThreadGrouper";
    private static final String OPTION_THREAD_DUMPER = "loadingProfiler_Option_AllThread";
    private static final String OPTION_ALLOC = "loadingProfiler_Option_MemAlloc";
    private static final String OPTION_ALLOC_INTERVAL = "loadingProfiler_Option_MemAllocInterval";
    private static final Map<StateEnum, Sampler> activeSamplers = new HashMap<StateEnum, Sampler>();

    public static void startForState(SparkPlugin plugin, SparkPlatform platform, StateEnum state) {
        if (!activeSamplers.containsKey((Object)state)) {
            AbstractSampler sampler;
            int interval;
            boolean memAlloc;
            boolean allowAsync = AsyncProfilerAccess.getInstance(platform).checkSupported(platform);
            boolean profAsync = platform.getConfiguration().getOrSaveString(OPTION_ENGINE, allowAsync ? "async" : "java").equals("async");
            if (profAsync && !allowAsync) {
                platform.getConfiguration().setString(OPTION_ENGINE, "java");
                platform.getConfiguration().save();
                profAsync = false;
                plugin.log(Level.INFO, "Loading Profiler is set to async sampling, but async is not supported, setting to java sampling");
            }
            if ((memAlloc = platform.getConfiguration().getOrSaveBoolean(OPTION_ALLOC, false)) && !allowAsync) {
                platform.getConfiguration().setBoolean(OPTION_ALLOC, false);
                platform.getConfiguration().save();
                memAlloc = false;
                plugin.log(Level.INFO, "Loading Profiler is set to memAlloc, but async is not supported, setting to java sampling");
            }
            boolean ignoreSleeping = platform.getConfiguration().getOrSaveBoolean(OPTION_IGNORE_SLEEPING, true);
            boolean ignoreNative = platform.getConfiguration().getOrSaveBoolean(OPTION_IGNORE_NATIVE, false);
            SamplerMode mode = memAlloc ? SamplerMode.ALLOCATION : SamplerMode.EXECUTION;
            Supplier<ThreadGrouper> threadGrouper = ThreadGrouper.parseConfigSetting(platform.getConfiguration().getOrSaveString(OPTION_THREAD_GROUPER, "by-pool"));
            ThreadDumper threadDumper = ThreadDumper.parseConfigSetting(platform.getConfiguration().getOrSaveBoolean(OPTION_THREAD_DUMPER, false) ? "all" : "default");
            if (threadDumper == null) {
                threadDumper = plugin.getDefaultThreadDumper();
            }
            if ((interval = platform.getConfiguration().getOrSaveInteger(mode == SamplerMode.ALLOCATION ? OPTION_ALLOC_INTERVAL : OPTION_INTERVAL, mode.defaultInterval())) <= 0) {
                interval = mode.defaultInterval();
            }
            interval = (int)(mode == SamplerMode.EXECUTION ? (double)interval * 1000.0 : (double)interval);
            SamplerSettings settings = new SamplerSettings(interval, threadDumper, threadGrouper.get(), -1L, false, false);
            try {
                sampler = mode == SamplerMode.ALLOCATION ? new AsyncSampler(platform, settings, new SampleCollector.Allocation(interval, false)) : (profAsync ? new AsyncSampler(platform, settings, new SampleCollector.Execution(interval)) : new JavaSampler(platform, settings, null, -1));
            }
            catch (Exception e) {
                plugin.log(Level.WARNING, "Loading Profiler has encountered an exception while attempting to start sampling state: " + state.getValue());
                e.printStackTrace();
                return;
            }
            activeSamplers.put(state, sampler);
            plugin.log(Level.INFO, "Loading Profiler has started sampling for loading stage: " + state.getValue());
            sampler.start();
            CompletableFuture<Sampler> future = sampler.getFuture();
            future.whenCompleteAsync((s, throwable) -> {
                if (throwable != null) {
                    plugin.log(Level.WARNING, "Loading Profiler sampler failed unexpectedly for state: " + state.getValue());
                    throwable.printStackTrace();
                }
            });
        } else {
            plugin.log(Level.WARNING, "Loading Profiler attempted to start a duplicate sampler for state: " + state.getValue());
        }
    }

    public static void stopForState(SparkPlugin plugin, SparkPlatform platform, StateEnum state) {
        Sampler sampler = activeSamplers.remove((Object)state);
        if (sampler != null) {
            sampler.stop(false);
            plugin.executeAsync(() -> {
                plugin.log(Level.INFO, "Loading Profiler has stopped profiling for loading state: " + state.getValue() + ", saving results, please wait...");
                SamplerModule.handleManualSaveFile(platform, sampler, new Sampler.ExportProps().creator(new CommandSender.Data("LoadingProfiler", null)).mergeStrategy(MergeStrategy.SAME_METHOD).classSourceLookup(() -> ClassSourceLookup.create(platform)), "forgeloading_" + state.getValue() + "_" + (FMLLaunchHandler.side() == Side.CLIENT ? "client" : "server") + (sampler.getMode() == SamplerMode.ALLOCATION ? "_memalloc" : ""));
            });
        }
    }

    public static void clearHangingSamplers(SparkPlugin plugin) {
        for (StateEnum state : StateEnum.values()) {
            Sampler sample = activeSamplers.remove((Object)state);
            if (sample == null) continue;
            sample.stop(true);
            plugin.log(Level.WARNING, "Loading Profiler detected hanging sampler for state: " + state.getValue() + ", clearing");
        }
    }
}

