/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.async;

import com.google.common.collect.ImmutableTable;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.sampler.async.AsyncProfilerJob;
import me.lucko.spark.lib.asyncprofiler.AsyncProfiler;

public class AsyncProfilerAccess {
    private static AsyncProfilerAccess instance;
    private final AsyncProfiler profiler;
    private final ProfilingEvent profilingEvent;
    private final ProfilingEvent allocationProfilingEvent;
    private final Exception setupException;

    public static synchronized AsyncProfilerAccess getInstance(SparkPlatform platform) {
        if (instance == null) {
            Objects.requireNonNull(platform, "platform");
            instance = new AsyncProfilerAccess(platform);
        }
        return instance;
    }

    AsyncProfilerAccess(SparkPlatform platform) {
        AsyncProfiler profiler;
        ProfilingEvent profilingEvent = null;
        ProfilingEvent allocationProfilingEvent = null;
        Exception setupException = null;
        try {
            profiler = AsyncProfilerAccess.load(platform);
            if (AsyncProfilerAccess.isEventSupported(profiler, ProfilingEvent.ALLOC, false)) {
                allocationProfilingEvent = ProfilingEvent.ALLOC;
            }
            if (AsyncProfilerAccess.isEventSupported(profiler, ProfilingEvent.WALL, true)) {
                profilingEvent = ProfilingEvent.WALL;
            }
        }
        catch (Exception e) {
            profiler = null;
            setupException = e;
        }
        this.profiler = profiler;
        this.profilingEvent = profilingEvent;
        this.allocationProfilingEvent = allocationProfilingEvent;
        this.setupException = setupException;
    }

    public AsyncProfilerJob startNewProfilerJob() {
        if (this.profiler == null) {
            throw new UnsupportedOperationException("async-profiler not supported", this.setupException);
        }
        return AsyncProfilerJob.createNew(this, this.profiler);
    }

    public ProfilingEvent getProfilingEvent() {
        return this.profilingEvent;
    }

    public ProfilingEvent getAllocationProfilingEvent() {
        return this.allocationProfilingEvent;
    }

    public boolean checkSupported(SparkPlatform platform) {
        if (this.setupException != null) {
            if (this.setupException instanceof UnsupportedSystemException) {
                platform.getPlugin().log(Level.INFO, "The async-profiler engine is not supported for your os/arch (" + this.setupException.getMessage() + "), so the built-in Java engine will be used instead.");
            } else if (this.setupException instanceof NativeLoadingException && this.setupException.getCause().getMessage().contains("libstdc++")) {
                platform.getPlugin().log(Level.WARNING, "Unable to initialise the async-profiler engine because libstdc++ is not installed.");
                platform.getPlugin().log(Level.WARNING, "Please see here for more information: https://spark.lucko.me/docs/misc/Using-async-profiler#install-libstdc");
            } else {
                platform.getPlugin().log(Level.WARNING, "Unable to initialise the async-profiler engine: " + this.setupException.getMessage());
                platform.getPlugin().log(Level.WARNING, "Please see here for more information: https://spark.lucko.me/docs/misc/Using-async-profiler");
                this.setupException.printStackTrace();
            }
        }
        return this.profiler != null;
    }

    public boolean checkAllocationProfilingSupported(SparkPlatform platform) {
        boolean supported;
        boolean bl = supported = this.allocationProfilingEvent != null;
        if (!supported && this.profiler != null) {
            platform.getPlugin().log(Level.WARNING, "The allocation profiling mode is not supported on your system. This is most likely because Hotspot debug symbols are not available.");
            platform.getPlugin().log(Level.WARNING, "To resolve, try installing the 'openjdk-11-dbg' or 'openjdk-8-dbg' package using your OS package manager.");
        }
        return supported;
    }

    public String getVersion() {
        return this.profiler.getVersion();
    }

    private static AsyncProfiler load(SparkPlatform platform) throws Exception {
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT).replace(" ", "");
        String arch = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        String jvm = System.getProperty("java.vm.name");
        ImmutableTable supported = ImmutableTable.builder().put((Object)"linux", (Object)"amd64", (Object)"linux/amd64").put((Object)"linux", (Object)"aarch64", (Object)"linux/aarch64").put((Object)"macosx", (Object)"amd64", (Object)"macos").put((Object)"macosx", (Object)"aarch64", (Object)"macos").build();
        String libPath = (String)supported.get((Object)os, (Object)arch);
        if (libPath == null) {
            throw new UnsupportedSystemException(os, arch);
        }
        String resource = "spark/" + libPath + "/libasyncProfiler.so";
        URL profilerResource = AsyncProfilerAccess.class.getClassLoader().getResource(resource);
        if (profilerResource == null) {
            throw new IllegalStateException("Could not find " + resource + " in spark jar file");
        }
        Path extractPath = platform.getTemporaryFiles().create("spark-", "-libasyncProfiler.so.tmp");
        try (InputStream in = profilerResource.openStream();
             OutputStream out = Files.newOutputStream(extractPath, new OpenOption[0]);){
            ByteStreams.copy((InputStream)in, (OutputStream)out);
        }
        try {
            return AsyncProfiler.getInstance(extractPath.toAbsolutePath().toString());
        }
        catch (UnsatisfiedLinkError e) {
            throw new NativeLoadingException(e);
        }
    }

    private static boolean isEventSupported(AsyncProfiler profiler, ProfilingEvent event, boolean throwException) {
        block4: {
            try {
                String resp = profiler.execute("check,event=" + (Object)((Object)event)).trim();
                if (resp.equalsIgnoreCase("ok")) {
                    return true;
                }
                if (throwException) {
                    throw new IllegalArgumentException(resp);
                }
            }
            catch (Exception e) {
                if (!throwException) break block4;
                throw new RuntimeException("Event " + (Object)((Object)event) + " is not supported", e);
            }
        }
        return false;
    }

    private static final class NativeLoadingException
    extends RuntimeException {
        public NativeLoadingException(Throwable cause) {
            super("A runtime error occurred whilst loading the native library", cause);
        }
    }

    private static final class UnsupportedSystemException
    extends UnsupportedOperationException {
        public UnsupportedSystemException(String os, String arch) {
            super(os + '/' + arch);
        }
    }

    public static enum ProfilingEvent {
        WALL("wall"),
        ALLOC("alloc");

        private final String id;

        private ProfilingEvent(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }
}

