/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.platform.world;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import me.lucko.spark.common.platform.world.AsyncWorldInfoProvider;
import me.lucko.spark.common.platform.world.ChunkInfo;
import me.lucko.spark.common.platform.world.CountMap;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import me.lucko.spark.proto.SparkProtos;
import org.jetbrains.annotations.VisibleForTesting;

public class WorldStatisticsProvider {
    private final AsyncWorldInfoProvider provider;

    public WorldStatisticsProvider(AsyncWorldInfoProvider provider) {
        this.provider = provider;
    }

    public SparkProtos.WorldStatistics getWorldStatistics() {
        Collection<WorldInfoProvider.DataPackInfo> dataPacks;
        WorldInfoProvider.ChunksResult<ChunkInfo<?>> result = this.provider.getChunks();
        if (result == null) {
            return null;
        }
        SparkProtos.WorldStatistics.Builder stats = SparkProtos.WorldStatistics.newBuilder();
        AtomicInteger combinedTotal = new AtomicInteger();
        CountMap.Simple combined = new CountMap.Simple(new HashMap());
        result.getWorlds().forEach((worldName, chunks) -> {
            SparkProtos.WorldStatistics.World.Builder builder = SparkProtos.WorldStatistics.World.newBuilder();
            builder.setName((String)worldName);
            List<Region> regions = WorldStatisticsProvider.groupIntoRegions(chunks);
            int total = 0;
            for (Region region : regions) {
                builder.addRegions(WorldStatisticsProvider.regionToProto(region, combined));
                total += region.getTotalEntities().get();
            }
            builder.setTotalEntities(total);
            combinedTotal.addAndGet(total);
            stats.addWorlds((SparkProtos.WorldStatistics.World)builder.build());
        });
        stats.setTotalEntities(combinedTotal.get());
        combined.asMap().forEach((key, value) -> stats.putEntityCounts((String)key, value.get()));
        WorldInfoProvider.GameRulesResult gameRules = this.provider.getGameRules();
        if (gameRules != null) {
            gameRules.getRules().forEach((ruleName, rule) -> stats.addGameRules((SparkProtos.WorldStatistics.GameRule)SparkProtos.WorldStatistics.GameRule.newBuilder().setName((String)ruleName).setDefaultValue(rule.getDefaultValue()).putAllWorldValues(rule.getWorldValues()).build()));
        }
        if ((dataPacks = this.provider.getDataPacks()) != null) {
            dataPacks.forEach(dataPack -> stats.addDataPacks((SparkProtos.WorldStatistics.DataPack)SparkProtos.WorldStatistics.DataPack.newBuilder().setName(dataPack.name()).setDescription(dataPack.description()).setSource(dataPack.source()).build()));
        }
        return (SparkProtos.WorldStatistics)stats.build();
    }

    private static SparkProtos.WorldStatistics.Region regionToProto(Region region, CountMap<String> combined) {
        SparkProtos.WorldStatistics.Region.Builder builder = SparkProtos.WorldStatistics.Region.newBuilder();
        builder.setTotalEntities(region.getTotalEntities().get());
        for (ChunkInfo<?> chunk : region.getChunks()) {
            builder.addChunks(WorldStatisticsProvider.chunkToProto(chunk, combined));
        }
        return (SparkProtos.WorldStatistics.Region)builder.build();
    }

    private static <E> SparkProtos.WorldStatistics.Chunk chunkToProto(ChunkInfo<E> chunk, CountMap<String> combined) {
        SparkProtos.WorldStatistics.Chunk.Builder builder = SparkProtos.WorldStatistics.Chunk.newBuilder();
        builder.setX(chunk.getX());
        builder.setZ(chunk.getZ());
        builder.setTotalEntities(chunk.getEntityCounts().total().get());
        chunk.getEntityCounts().asMap().forEach((key, value) -> {
            String name = chunk.entityTypeName(key);
            int count = value.get();
            if (name == null) {
                name = "unknown[" + key.toString() + "]";
            }
            builder.putEntityCounts(name, count);
            combined.add(name, count);
        });
        return (SparkProtos.WorldStatistics.Chunk)builder.build();
    }

    @VisibleForTesting
    static List<Region> groupIntoRegions(List<? extends ChunkInfo<?>> chunks) {
        ArrayList<Region> regions = new ArrayList<Region>();
        LinkedHashMap chunkMap = new LinkedHashMap(chunks.size());
        for (ChunkInfo<?> chunk : chunks) {
            CountMap<?> counts = chunk.getEntityCounts();
            if (counts.total().get() == 0) continue;
            chunkMap.put(new ChunkCoordinate(chunk.getX(), chunk.getZ()), chunk);
        }
        ArrayDeque<ChunkInfo> queue = new ArrayDeque<ChunkInfo>();
        ChunkCoordinate index = new ChunkCoordinate();
        while (!chunkMap.isEmpty()) {
            ChunkInfo queued;
            Map.Entry first = chunkMap.entrySet().iterator().next();
            ChunkInfo firstValue = (ChunkInfo)first.getValue();
            chunkMap.remove(first.getKey());
            Region region = new Region(firstValue);
            regions.add(region);
            queue.add(firstValue);
            while ((queued = (ChunkInfo)queue.pollFirst()) != null) {
                int queuedX = queued.getX();
                int queuedZ = queued.getZ();
                for (int dz = -1; dz <= 1; ++dz) {
                    for (int dx = -1; dx <= 1; ++dx) {
                        if ((dx | dz) == 0) continue;
                        index.setCoordinate(queuedX + dx, queuedZ + dz);
                        ChunkInfo adjacent = (ChunkInfo)chunkMap.remove(index);
                        if (adjacent == null) continue;
                        region.add(adjacent);
                        queue.add(adjacent);
                    }
                }
            }
        }
        return regions;
    }

    static final class ChunkCoordinate
    implements Comparable<ChunkCoordinate> {
        long key;

        ChunkCoordinate() {
        }

        ChunkCoordinate(int chunkX, int chunkZ) {
            this.setCoordinate(chunkX, chunkZ);
        }

        ChunkCoordinate(long key) {
            this.setKey(key);
        }

        public void setCoordinate(int chunkX, int chunkZ) {
            this.setKey((long)chunkZ << 32 | (long)chunkX & 0xFFFFFFFFL);
        }

        public void setKey(long key) {
            this.key = key;
        }

        public int hashCode() {
            long h = this.key * -7046029254386353131L;
            h ^= h >>> 32;
            return (int)h;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ChunkCoordinate)) {
                return false;
            }
            return this.key == ((ChunkCoordinate)obj).key;
        }

        @Override
        public int compareTo(ChunkCoordinate other) {
            return Long.compare(this.key, other.key);
        }
    }

    static final class Region {
        private final Set<ChunkInfo<?>> chunks = new HashSet();
        private final AtomicInteger totalEntities;

        private Region(ChunkInfo<?> initial) {
            this.chunks.add(initial);
            this.totalEntities = new AtomicInteger(initial.getEntityCounts().total().get());
        }

        public Set<ChunkInfo<?>> getChunks() {
            return this.chunks;
        }

        public AtomicInteger getTotalEntities() {
            return this.totalEntities;
        }

        public void add(ChunkInfo<?> chunk) {
            this.chunks.add(chunk);
            this.totalEntities.addAndGet(chunk.getEntityCounts().total().get());
        }
    }
}

