/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.monitor;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum MacosSysctl {
    SYSCTL("sysctl", "-a");

    private static final boolean SUPPORTED;
    private final String[] cmdArgs;

    private MacosSysctl(String ... cmdArgs) {
        this.cmdArgs = cmdArgs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public @NonNull List<String> read() {
        if (!SUPPORTED) return Collections.emptyList();
        ProcessBuilder process = new ProcessBuilder(this.cmdArgs).redirectErrorStream(true);
        try (BufferedReader buf = new BufferedReader(new InputStreamReader(process.start().getInputStream()));){
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = buf.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    static {
        SUPPORTED = System.getProperty("os.name").toLowerCase(Locale.ROOT).replace(" ", "").equals("macosx");
    }
}

