/*
 * Decompiled with CFR 0.152.
 */
package vcfix.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import noppes.vc.VCBlocks;
import noppes.vc.client.gui.GuiCarpentryBench;
import noppes.vc.containers.ContainerCarpentryBench;
import vcfix.jei.CarpentryBenchRecipeCategory;
import vcfix.jei.CarpentryBenchRecipeWrapper;
import vcfix.jei.CarpentryBenchShapedRecipeWrapper;

@JEIPlugin
public class VCJEIPlugin
implements IModPlugin {
    public void register(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CarpentryBenchRecipeCategory(guiHelper)});
        registry.addRecipes(VCJEIPlugin.getBigRecipes(jeiHelpers), "vc.carpentrybench");
        registry.addRecipeClickArea(GuiCarpentryBench.class, 97, 38, 28, 23, new String[]{"vc.carpentrybench", "minecraft.crafting"});
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler(ContainerCarpentryBench.class, "vc.carpentrybench", 1, 16, 17, 36);
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new IRecipeTransferInfo<ContainerCarpentryBench>(){

            @Nonnull
            public Class<ContainerCarpentryBench> getContainerClass() {
                return ContainerCarpentryBench.class;
            }

            @Nonnull
            public String getRecipeCategoryUid() {
                return "minecraft.crafting";
            }

            public boolean canHandle(@Nonnull ContainerCarpentryBench container) {
                return true;
            }

            @Nonnull
            public List<Slot> getInventorySlots(@Nonnull ContainerCarpentryBench container) {
                return IntStream.range(17, 53).mapToObj(arg_0 -> ((ContainerCarpentryBench)container).func_75139_a(arg_0)).collect(Collectors.toList());
            }

            @Nonnull
            public List<Slot> getRecipeSlots(@Nonnull ContainerCarpentryBench container) {
                return Arrays.stream(new int[]{1, 2, 3, 5, 6, 7, 9, 10, 11}).mapToObj(arg_0 -> ((ContainerCarpentryBench)container).func_75139_a(arg_0)).collect(Collectors.toList());
            }
        });
        registry.addRecipeCatalyst((Object)new ItemStack(VCBlocks.carpentry_bench), new String[]{"vc.carpentrybench"});
    }

    public static List<CarpentryBenchRecipeWrapper<? extends IRecipe>> getBigRecipes(IJeiHelpers jeiHelpers) {
        ArrayList<CarpentryBenchRecipeWrapper<? extends IRecipe>> recipes = new ArrayList<CarpentryBenchRecipeWrapper<? extends IRecipe>>();
        for (IRecipe recipe : ForgeRegistries.RECIPES) {
            if (!VCJEIPlugin.isBigRecipe(recipe)) continue;
            if (recipe instanceof IShapedRecipe) {
                recipes.add(new CarpentryBenchShapedRecipeWrapper(jeiHelpers, (IShapedRecipe)recipe));
                continue;
            }
            recipes.add(new CarpentryBenchRecipeWrapper<IRecipe>(jeiHelpers, recipe));
        }
        return recipes;
    }

    public static boolean isBigRecipe(IRecipe recipe) {
        int recipeHeight = recipe instanceof IShapedRecipe ? ((IShapedRecipe)recipe).getRecipeHeight() : -1;
        int recipeWidth = recipe instanceof IShapedRecipe ? ((IShapedRecipe)recipe).getRecipeWidth() : -1;
        return recipeHeight == 4 || recipeWidth == 4 || recipe.func_192400_c().size() > 9 && recipe.func_192400_c().size() <= 16;
    }
}

