/*
 * Decompiled with CFR 0.152.
 */
package vcfix.jei;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import noppes.vc.VCBlocks;
import vcfix.jei.ArbitrarySizeCraftingGridHelper;

public class CarpentryBenchRecipeCategory
implements IRecipeCategory<IRecipeWrapper> {
    public static final String UID = "vc.carpentrybench";
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 1;
    private final ICraftingGridHelper craftingGridHelper;
    private final IDrawable icon;
    private final IDrawable background;

    public CarpentryBenchRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("variedcommodities:textures/gui/carpentry.png"), 16, 13, 138, 72);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(VCBlocks.carpentry_bench));
        this.craftingGridHelper = new ArbitrarySizeCraftingGridHelper(1, 0, 4, 4);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return VCBlocks.carpentry_bench.func_149732_F();
    }

    @Nonnull
    public String getModName() {
        return "Varied Commodities";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        ICraftingRecipeWrapper craftingRecipeWrapper;
        ResourceLocation registryName;
        int slot = 0;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(slot, false, 116, 27);
        slot = 1;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                guiItemStacks.init(slot++, true, x * 18, y * 18);
            }
        }
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        if (recipeWrapper instanceof IShapedCraftingRecipeWrapper) {
            IShapedCraftingRecipeWrapper wrapper = (IShapedCraftingRecipeWrapper)recipeWrapper;
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, wrapper.getWidth(), wrapper.getHeight());
        } else {
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs);
            recipeLayout.setShapeless();
        }
        guiItemStacks.set(0, (List)outputs.get(0));
        if (recipeWrapper instanceof ICraftingRecipeWrapper && (registryName = (craftingRecipeWrapper = (ICraftingRecipeWrapper)recipeWrapper).getRegistryName()) != null) {
            guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (slotIndex == 0) {
                    boolean showAdvanced;
                    String modName;
                    String recipeModId = registryName.func_110624_b();
                    boolean modIdDifferent = false;
                    ResourceLocation itemRegistryName = ingredient.func_77973_b().getRegistryName();
                    if (itemRegistryName != null) {
                        String itemModId = itemRegistryName.func_110624_b();
                        boolean bl = modIdDifferent = !recipeModId.equals(itemModId);
                    }
                    if (modIdDifferent && (modName = ForgeModIdHelper.getInstance().getFormattedModNameForModId(recipeModId)) != null) {
                        tooltip.add(TextFormatting.GRAY + Translator.translateToLocalFormatted((String)"jei.tooltip.recipe.by", (Object[])new Object[]{modName}));
                    }
                    boolean bl = showAdvanced = Minecraft.func_71410_x().field_71474_y.field_82882_x || GuiScreen.func_146272_n();
                    if (showAdvanced) {
                        tooltip.add(TextFormatting.DARK_GRAY + Translator.translateToLocalFormatted((String)"jei.tooltip.recipe.id", (Object[])new Object[]{registryName.toString()}));
                    }
                }
            });
        }
    }
}

