/*
 * Decompiled with CFR 0.152.
 */
package vcfix.jei;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.gui.CraftingGridHelper;
import net.minecraft.item.ItemStack;
import vcfix.VCFix;

public class ArbitrarySizeCraftingGridHelper
extends CraftingGridHelper {
    private final int craftInputSlot1;
    private final int maxWidth;
    private final int maxHeight;

    public ArbitrarySizeCraftingGridHelper(int craftInputSlot1, int craftOutputSlot, int maxWidth, int maxHeight) {
        super(craftInputSlot1, craftOutputSlot);
        this.craftInputSlot1 = craftInputSlot1;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    public <T> void setInputs(@Nonnull IGuiIngredientGroup<T> ingredientGroup, @Nonnull List<List<T>> inputs) {
        this.setInputs(ingredientGroup, inputs, this.maxWidth, this.maxHeight);
    }

    public <T> void setInputs(@Nonnull IGuiIngredientGroup<T> ingredientGroup, @Nonnull List<List<T>> inputs, int width, int height) {
        if (width > this.maxWidth || height > this.maxHeight || inputs.size() > this.maxHeight * this.maxWidth) {
            VCFix.LOGGER.warn("Recipe doesn't fit, aborting transfer");
            return;
        }
        for (int i = 0; i < inputs.size(); ++i) {
            ingredientGroup.set(this.craftInputSlot1 + this.getCraftingIndex(i, width), inputs.get(i));
        }
    }

    private int getCraftingIndex(int indexInInputList, int recipeWidth) {
        int row = indexInInputList / recipeWidth;
        int col = indexInInputList % recipeWidth;
        return row * this.maxWidth + col;
    }

    @Deprecated
    public void setInputStacks(@Nonnull IGuiItemStackGroup guiItemStacks, @Nonnull List<List<ItemStack>> input) {
        VCFix.LOGGER.warn("ICraftingGridHelper.setInputStacks(group, stacks) is deprecated and not implemented in ArbitrarySizeCraftingGridHelper. Use setInputs");
    }

    @Deprecated
    public void setInputStacks(@Nonnull IGuiItemStackGroup guiItemStacks, @Nonnull List<List<ItemStack>> input, int width, int height) {
        VCFix.LOGGER.warn("ICraftingGridHelper.setInputStacks(group, stacks, width, height) is deprecated and not implemented in ArbitrarySizeCraftingGridHelper. Use setInputs");
    }
}

