/*
 * Decompiled with CFR 0.152.
 */
package vcfix;

import fermiumbooter.annotations.MixinConfig;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="vcfix")
public class VCFixConfig {
    @Config.Comment(value={"Server-Side Options"})
    @Config.Name(value="Server Options")
    public static final ServerConfig server = new ServerConfig();
    @Config.Comment(value={"Client-Side Options"})
    @Config.Name(value="Client Options")
    public static final ClientConfig client = new ClientConfig();

    @Mod.EventBusSubscriber(modid="vcfix")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("vcfix")) {
                ConfigManager.sync((String)"vcfix", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    @MixinConfig(name="vcfix")
    public static class ClientConfig {
        @Config.Comment(value={"Enable the normal number key behavior inside the carpentry bench GUI. Number keys will swap the stack in the currently hovered-over slot with the stack in the selected number key hotbar slot."})
        @Config.Name(value="Bench - GUI Allow Number Hotkeys")
        @MixinConfig.MixinToggle(lateMixin="mixins.vcfix.vc.numberhotkeysingui.json", defaultValue=true)
        public boolean allowNumberKeysBenchGUI = true;
    }

    @MixinConfig(name="vcfix")
    public static class ServerConfig {
        @Config.Comment(value={"Shift clicking on an item inside the hotbar will try to move it first into the crafting grid of the carpentry bench."})
        @Config.Name(value="Bench - Better Shift Click - From Hotbar")
        @MixinConfig.MixinToggle(lateMixin="mixins.vcfix.vc.shiftclickhotbar.json", defaultValue=true)
        public boolean shiftClickHotBarToBench = true;
        @Config.Comment(value={"Shift clicking on an item inside the player inventory will try to move it first into the crafting grid of the carpentry bench."})
        @Config.Name(value="Bench - Better Shift Click - From Inventory")
        @MixinConfig.MixinToggle(lateMixin="mixins.vcfix.vc.shiftclickinventory.json", defaultValue=true)
        public boolean shiftClickInventoryToBench = true;
        @Config.Comment(value={"Exiting out of the Carpentry Bench GUI will now first try to place the items inside the crafting grid back into the players inventory before dropping onto the ground."})
        @Config.Name(value="Bench - Stop Drop On GUI Exit")
        @MixinConfig.MixinToggle(lateMixin="mixins.vcfix.vc.stopdrop.json", defaultValue=true)
        public boolean stopDroppingOnExit = true;
        @Config.Comment(value={"JEI sends warnings when big recipes are registered that won't fit the normal crafting table. This disables those warnings if the recipe fits into the carpentry bench."})
        @Config.Name(value="JEI - Stop Log Warn Spam")
        @MixinConfig.MixinToggle(lateMixin="mixins.vcfix.jei.stoplogspam.json", defaultValue=true)
        public boolean stopLogSpamBigRecipes = true;
    }
}

