/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.network;

import com.yyon.grapplinghook.controllers.SegmentHandler;
import com.yyon.grapplinghook.entities.grappleArrow;
import com.yyon.grapplinghook.vec;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SegmentMessage
implements IMessage {
    public int id;
    public boolean add;
    public int index;
    public vec pos;
    public EnumFacing topfacing;
    public EnumFacing bottomfacing;

    public SegmentMessage() {
    }

    public SegmentMessage(int id, boolean add, int index, vec pos, EnumFacing topfacing, EnumFacing bottomfacing) {
        this.id = id;
        this.add = add;
        this.index = index;
        this.pos = pos;
        this.topfacing = topfacing;
        this.bottomfacing = bottomfacing;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.add = buf.readBoolean();
        this.index = buf.readInt();
        this.pos = new vec(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.topfacing = EnumFacing.func_82600_a((int)buf.readInt());
        this.bottomfacing = EnumFacing.func_82600_a((int)buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeBoolean(this.add);
        buf.writeInt(this.index);
        buf.writeDouble(this.pos.x);
        buf.writeDouble(this.pos.y);
        buf.writeDouble(this.pos.z);
        buf.writeInt(this.topfacing.func_176745_a());
        buf.writeInt(this.bottomfacing.func_176745_a());
    }

    public static class Handler
    implements IMessageHandler<SegmentMessage, IMessage> {
        public IMessage onMessage(SegmentMessage message, MessageContext ctx) {
            Minecraft mainThread = Minecraft.func_71410_x();
            mainThread.func_152344_a((Runnable)new runner(message, ctx));
            return null;
        }

        public class runner
        implements Runnable {
            SegmentMessage message;
            MessageContext ctx;

            public runner(SegmentMessage message, MessageContext ctx) {
                this.message = message;
                this.ctx = ctx;
            }

            @Override
            public void run() {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                Entity grapple = world.func_73045_a(this.message.id);
                if (grapple == null) {
                    return;
                }
                if (grapple instanceof grappleArrow) {
                    SegmentHandler segmenthandler = ((grappleArrow)grapple).segmenthandler;
                    if (this.message.add) {
                        segmenthandler.actuallyaddsegment(this.message.index, this.message.pos, this.message.bottomfacing, this.message.topfacing);
                    } else {
                        segmenthandler.removesegment(this.message.index);
                    }
                }
            }
        }
    }
}

