/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.network;

import com.yyon.grapplinghook.grapplemod;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PlayerMovementMessage
implements IMessage {
    public int entityId;
    public double x;
    public double y;
    public double z;
    public double mx;
    public double my;
    public double mz;

    public PlayerMovementMessage() {
    }

    public PlayerMovementMessage(int entityId, double x, double y, double z, double mx, double my, double mz) {
        this.entityId = entityId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.mx = mx;
        this.my = my;
        this.mz = mz;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.entityId = buf.readInt();
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
            this.mx = buf.readDouble();
            this.my = buf.readDouble();
            this.mz = buf.readDouble();
        }
        catch (Exception e) {
            System.out.print("Playermovement error: ");
            System.out.println(buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.mx);
        buf.writeDouble(this.my);
        buf.writeDouble(this.mz);
    }

    public static class Handler
    implements IMessageHandler<PlayerMovementMessage, IMessage> {
        public IMessage onMessage(PlayerMovementMessage message, MessageContext ctx) {
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a((Runnable)new runner(message, ctx));
            return null;
        }

        public class runner
        implements Runnable {
            PlayerMovementMessage message;
            MessageContext ctx;

            public runner(PlayerMovementMessage message, MessageContext ctx) {
                this.message = message;
                this.ctx = ctx;
            }

            @Override
            public void run() {
                World world = this.ctx.getServerHandler().field_147369_b.field_70170_p;
                Entity entity = world.func_73045_a(this.message.entityId);
                if (entity == null) {
                    return;
                }
                if (entity instanceof EntityPlayerMP) {
                    EntityPlayerMP referencedPlayer = (EntityPlayerMP)entity;
                    if (this.ctx.getServerHandler().field_147369_b.func_146103_bH().equals((Object)referencedPlayer.func_146103_bH())) {
                        entity.field_70165_t = this.message.x;
                        entity.field_70163_u = this.message.y;
                        entity.field_70161_v = this.message.z;
                        entity.field_70159_w = this.message.mx;
                        entity.field_70181_x = this.message.my;
                        entity.field_70179_y = this.message.mz;
                        EntityPlayerMP player = (EntityPlayerMP)entity;
                        Method capturePositionMethod = grapplemod.proxy.getCapturePositionMethod();
                        if (capturePositionMethod != null) {
                            try {
                                capturePositionMethod.invoke((Object)player.field_71135_a, new Object[0]);
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            catch (IllegalArgumentException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                        } else {
                            System.out.println("Error capturePositionMethod is null");
                        }
                        if (!player.field_70122_E) {
                            if (this.message.my >= 0.0) {
                                player.field_70143_R = 0.0f;
                            } else {
                                double gravity = 0.1;
                                player.field_70143_R = (float)(Math.pow(this.message.my, 2.0) / (2.0 * gravity));
                            }
                        }
                    }
                }
            }
        }
    }
}

