/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.client;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import noppes.vc.VariedCommodities;

public class VCResourceLoader
implements IResourceManagerReloadListener {
    public void func_110549_a(IResourceManager var1) {
        if (var1 instanceof SimpleReloadableResourceManager) {
            this.createTextureCache();
        }
    }

    private void createTextureCache() {
        this.enlargeTexture("planks_oak");
        this.enlargeTexture("planks_big_oak");
        this.enlargeTexture("planks_birch");
        this.enlargeTexture("planks_jungle");
        this.enlargeTexture("planks_spruce");
        this.enlargeTexture("planks_acacia");
        this.enlargeTexture("iron_block");
        this.enlargeTexture("diamond_block");
        this.enlargeTexture("stone");
        this.enlargeTexture("gold_block");
        this.enlargeTexture("wool_colored_white");
    }

    private void enlargeTexture(String texture) {
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        if (manager == null) {
            return;
        }
        ResourceLocation location = new ResourceLocation("variedcommodities", "textures/cache/" + texture + ".png");
        Object ob = manager.func_110581_b(location);
        if (ob == null || !(ob instanceof TextureCache)) {
            ob = new TextureCache(location);
            manager.func_110579_a(location, ob);
        }
        ((TextureCache)((Object)ob)).setImage(new ResourceLocation("textures/blocks/" + texture + ".png"));
    }

    class TextureCache
    extends SimpleTexture {
        private BufferedImage bufferedImage;
        private boolean textureUploaded;

        public TextureCache(ResourceLocation location) {
            super(location);
        }

        public int func_110552_b() {
            this.checkTextureUploaded();
            return super.func_110552_b();
        }

        private void checkTextureUploaded() {
            if (!this.textureUploaded && this.bufferedImage != null) {
                if (this.field_110568_b != null && this.field_110553_a != -1) {
                    TextureUtil.func_147942_a((int)this.field_110553_a);
                    this.field_110553_a = -1;
                }
                TextureUtil.func_110987_a((int)super.func_110552_b(), (BufferedImage)this.bufferedImage);
                this.textureUploaded = true;
            }
        }

        public void setImage(ResourceLocation location) {
            try {
                IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
                BufferedImage bufferedimage = ImageIO.read(manager.func_110536_a(location).func_110527_b());
                int i = bufferedimage.getWidth();
                int j = bufferedimage.getHeight();
                this.bufferedImage = new BufferedImage(i * 4, j * 2, 1);
                Graphics g = this.bufferedImage.getGraphics();
                g.drawImage(bufferedimage, 0, 0, null);
                g.drawImage(bufferedimage, i, 0, null);
                g.drawImage(bufferedimage, i * 2, 0, null);
                g.drawImage(bufferedimage, i * 3, 0, null);
                g.drawImage(bufferedimage, 0, i, null);
                g.drawImage(bufferedimage, i, j, null);
                g.drawImage(bufferedimage, i * 2, j, null);
                g.drawImage(bufferedimage, i * 3, j, null);
                this.textureUploaded = false;
            }
            catch (Exception e) {
                VariedCommodities.Log.error("Failed caching texture: " + location, (Throwable)e);
            }
        }

        public void func_110551_a(IResourceManager resourceManager) throws IOException {
        }
    }
}

