/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks;

import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rustic.common.blocks.BlockFallingBase;
import rustic.common.blocks.BlockRopeBase;
import rustic.core.Rustic;

public class BlockChandelier
extends BlockFallingBase {
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);

    public BlockChandelier() {
        this("chandelier");
    }

    public BlockChandelier(String name) {
        this(Material.field_151573_f, name, true);
    }

    public BlockChandelier(Material mat, String name, boolean register) {
        super(mat, name, register);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185858_k);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess ba, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.UP && side != EnumFacing.DOWN;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    protected void func_149829_a(EntityFallingBlock fallingEntity) {
        fallingEntity.func_145806_a(true);
        for (Field field : fallingEntity.getClass().getDeclaredFields()) {
            if (field.getName().equals("fallHurtMax") || field.getName().equals("field_145815_h")) {
                field.setAccessible(true);
                try {
                    field.setInt(fallingEntity, 400);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    Rustic.logger.warn("Error setting falling chandelier maximum damage with reflection", (Throwable)e);
                }
                continue;
            }
            if (!field.getName().equals("fallHurtAmount") && !field.getName().equals("field_145816_i")) continue;
            field.setAccessible(true);
            try {
                field.setFloat(fallingEntity, 6.0f);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Rustic.logger.warn("Error setting falling chandelier damage with reflection", (Throwable)e);
            }
        }
    }

    public void func_176502_a_(World worldIn, BlockPos pos, IBlockState p_176502_3_, IBlockState p_176502_4_) {
        worldIn.func_175718_b(1031, pos, 0);
    }

    public void func_190974_b(World worldIn, BlockPos pos) {
        worldIn.func_175718_b(1029, pos, 0);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            this.checkFallable(worldIn, pos);
        }
    }

    private boolean suspended(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177984_a());
        if (worldIn.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN, false)) {
            return true;
        }
        return state.func_177230_c() instanceof BlockRopeBase && state.func_177229_b(BlockRopeBase.AXIS) == EnumFacing.Axis.Y;
    }

    private void checkFallable(World worldIn, BlockPos pos) {
        if ((worldIn.func_175623_d(pos.func_177977_b()) || BlockChandelier.func_185759_i((IBlockState)worldIn.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0 && !this.suspended(worldIn, pos)) {
            if (!field_149832_M && worldIn.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                if (!worldIn.field_72995_K) {
                    EntityFallingBlock entityfallingblock = new EntityFallingBlock(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos));
                    this.func_149829_a(entityfallingblock);
                    worldIn.func_72838_d((Entity)entityfallingblock);
                }
            } else {
                IBlockState state = worldIn.func_180495_p(pos);
                worldIn.func_175698_g(pos);
                BlockPos blockpos = pos.func_177977_b();
                while ((worldIn.func_175623_d(blockpos) || BlockChandelier.func_185759_i((IBlockState)worldIn.func_180495_p(blockpos))) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    worldIn.func_175656_a(blockpos.func_177984_a(), state);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return BlockFaceShape.BOWL;
        }
        if (side == EnumFacing.UP) {
            return BlockFaceShape.CENTER;
        }
        return BlockFaceShape.SOLID;
    }
}

