/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.utils;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.placeholders.ItemPlaceholder;
import betterquesting.api.placeholders.PlaceholderConverter;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.utils.BQThreadedIO;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.Level;

public class JsonHelper {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static JsonArray GetArray(@Nonnull JsonObject json, @Nonnull String id) {
        if (json.get(id) instanceof JsonArray) {
            return json.get(id).getAsJsonArray();
        }
        return new JsonArray();
    }

    public static JsonObject GetObject(@Nonnull JsonObject json, @Nonnull String id) {
        if (json.get(id) instanceof JsonObject) {
            return json.get(id).getAsJsonObject();
        }
        return new JsonObject();
    }

    public static String GetString(@Nonnull JsonObject json, @Nonnull String id, String def) {
        if (json.get(id) instanceof JsonPrimitive && json.get(id).getAsJsonPrimitive().isString()) {
            return json.get(id).getAsString();
        }
        return def;
    }

    public static Number GetNumber(@Nonnull JsonObject json, @Nonnull String id, Number def) {
        if (json.get(id) instanceof JsonPrimitive) {
            try {
                return json.get(id).getAsNumber();
            }
            catch (Exception e) {
                return def;
            }
        }
        return def;
    }

    public static boolean GetBoolean(@Nonnull JsonObject json, @Nonnull String id, boolean def) {
        if (json.get(id) instanceof JsonPrimitive) {
            try {
                return json.get(id).getAsBoolean();
            }
            catch (Exception e) {
                return def;
            }
        }
        return def;
    }

    public static ArrayList<JsonElement> GetUnderlyingArray(JsonArray array) {
        try {
            Field field = JsonArray.class.getDeclaredField("elements");
            field.setAccessible(true);
            return (ArrayList)field.get(array);
        }
        catch (Exception e) {
            QuestingAPI.getLogger().log(Level.ERROR, "Unable to retrieve underlying JsonArray:", (Throwable)e);
            return null;
        }
    }

    public static void ClearCompoundTag(@Nonnull NBTTagCompound tag) {
        ArrayList<String> list = new ArrayList<String>(tag.func_150296_c());
        list.forEach(arg_0 -> ((NBTTagCompound)tag).func_82580_o(arg_0));
    }

    public static JsonObject ReadFromFile(File file) {
        if (file == null || !file.exists()) {
            return new JsonObject();
        }
        Future<JsonObject> task = BQThreadedIO.INSTANCE.enqueue(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        try {
            return task.get();
        }
        catch (Exception e) {
            QuestingAPI.getLogger().error("Unable to read from file " + file, (Throwable)e);
            return new JsonObject();
        }
    }

    public static void WriteToFile(File file, JsonObject jObj) {
        File tmp = new File(file.getAbsolutePath() + ".tmp");
        BQThreadedIO.INSTANCE.enqueue(() -> {
            Throwable throwable;
            Throwable throwable2;
            try {
                if (tmp.exists()) {
                    tmp.delete();
                } else if (tmp.getParentFile() != null) {
                    tmp.getParentFile().mkdirs();
                }
                tmp.createNewFile();
            }
            catch (Exception e) {
                QuestingAPI.getLogger().error("An error occured while saving JSON to file (Directory setup):", (Throwable)e);
                return;
            }
            try {
                throwable2 = null;
                try (FileOutputStream fos = new FileOutputStream(tmp);){
                    throwable = null;
                    try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
                        GSON.toJson((JsonElement)jObj, (Appendable)fw);
                        fw.flush();
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Throwable fw) {
                    throwable2 = fw;
                    throw fw;
                }
            }
            catch (Exception e) {
                QuestingAPI.getLogger().error("An error occured while saving JSON to file (File write):", (Throwable)e);
                return;
            }
            try {
                throwable2 = null;
                try (FileInputStream fis = new FileInputStream(tmp);){
                    throwable = null;
                    try (InputStreamReader fr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);){
                        GSON.fromJson((Reader)fr, JsonObject.class);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
            }
            catch (Exception e) {
                QuestingAPI.getLogger().error("An error occured while saving JSON to file (Validation check):", (Throwable)e);
                return;
            }
            try {
                if (file.exists()) {
                    file.delete();
                }
                tmp.renameTo(file);
            }
            catch (Exception e) {
                QuestingAPI.getLogger().error("An error occured while saving JSON to file (Temp copy):", (Throwable)e);
            }
        });
    }

    public static void CopyPaste(File fileIn, File fileOut) {
        if (!fileIn.exists()) {
            return;
        }
        try {
            if (fileOut.getParentFile() != null) {
                fileOut.getParentFile().mkdirs();
            }
            Files.copy(fileIn.toPath(), fileOut.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            QuestingAPI.getLogger().log(Level.ERROR, "Failed copy paste", (Throwable)e);
        }
    }

    public static String makeFileNameSafe(String s) {
        for (char c : ChatAllowedCharacters.field_71567_b) {
            s = s.replace(c, '_');
        }
        return s;
    }

    public static boolean isItem(NBTTagCompound json) {
        if (json != null && json.func_74764_b("id") && json.func_150297_b("Count", 99) && json.func_150297_b("Damage", 99)) {
            if (json.func_150297_b("id", 8)) {
                return Item.field_150901_e.func_148741_d((Object)new ResourceLocation(json.func_74779_i("id")));
            }
            return Item.field_150901_e.func_148754_a(json.func_74762_e("id")) != null;
        }
        return false;
    }

    public static boolean isFluid(NBTTagCompound json) {
        return json != null && json.func_150297_b("FluidName", 8) && json.func_150297_b("Amount", 99) && FluidRegistry.getFluid((String)json.func_74779_i("FluidName")) != null;
    }

    public static boolean isEntity(NBTTagCompound tags) {
        return tags.func_74764_b("id") && EntityList.func_180125_b((ResourceLocation)new ResourceLocation(tags.func_74779_i("id")));
    }

    public static BigItemStack JsonToItemStack(NBTTagCompound nbt) {
        Item preCheck = Item.func_111206_d((String)(nbt.func_150297_b("id", 99) ? "" + nbt.func_74765_d("id") : nbt.func_74779_i("id")));
        if (preCheck != null && preCheck != ItemPlaceholder.placeholder) {
            return new BigItemStack(nbt);
        }
        return PlaceholderConverter.convertItem(preCheck, nbt.func_74779_i("id"), nbt.func_74762_e("Count"), nbt.func_74765_d("Damage"), nbt.func_74779_i("OreDict"), !nbt.func_150297_b("tag", 10) ? null : nbt.func_74775_l("tag"));
    }

    public static NBTTagCompound ItemStackToJson(BigItemStack stack, NBTTagCompound nbt) {
        if (stack != null) {
            stack.writeToNBT(nbt);
        }
        return nbt;
    }

    public static FluidStack JsonToFluidStack(NBTTagCompound json) {
        String name = json.func_150297_b("FluidName", 8) ? json.func_74779_i("FluidName") : "water";
        int amount = json.func_74762_e("Amount");
        NBTTagCompound tags = !json.func_150297_b("Tag", 10) ? null : json.func_74775_l("Tag");
        Fluid fluid = FluidRegistry.getFluid((String)name);
        return PlaceholderConverter.convertFluid(fluid, name, amount, tags);
    }

    public static NBTTagCompound FluidStackToJson(FluidStack stack, NBTTagCompound json) {
        if (stack == null) {
            return json;
        }
        json.func_74778_a("FluidName", FluidRegistry.getFluidName((FluidStack)stack));
        json.func_74768_a("Amount", stack.amount);
        if (stack.tag != null) {
            json.func_74782_a("Tag", (NBTBase)stack.tag);
        }
        return json;
    }

    public static Entity JsonToEntity(NBTTagCompound tags, World world) {
        Entity entity = null;
        if (tags.func_74764_b("id") && EntityList.func_180125_b((ResourceLocation)new ResourceLocation(tags.func_74779_i("id")))) {
            entity = EntityList.func_75615_a((NBTTagCompound)tags, (World)world);
        }
        return PlaceholderConverter.convertEntity(entity, world, tags);
    }

    public static NBTTagCompound EntityToJson(Entity entity, NBTTagCompound json) {
        if (entity == null) {
            return json;
        }
        NBTTagCompound tags = new NBTTagCompound();
        entity.func_70039_c(tags);
        String id = EntityList.func_75621_b((Entity)entity);
        tags.func_74778_a("id", id != null ? id : "");
        json.func_179237_a(tags);
        return json;
    }
}

