/*
 * Decompiled with CFR 0.152.
 */
package meldexun.reflectionutil;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ReflectionConstructor<C> {
    private final Constructor<C> constructor;

    public ReflectionConstructor(Constructor<C> constructor) {
        this.constructor = constructor;
    }

    public ReflectionConstructor(Class<C> clazz, Class<?> ... parameterTypes) {
        Constructor<C> c = null;
        try {
            c = clazz.getDeclaredConstructor(parameterTypes);
            c.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.constructor = c;
    }

    public ReflectionConstructor(String className, Class<?> ... parameterTypes) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.constructor = null;
            return;
        }
        Constructor<?> c = null;
        try {
            c = clazz.getDeclaredConstructor(parameterTypes);
            c.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.constructor = c;
    }

    public C newInstance(Object ... initargs) {
        try {
            return this.constructor.newInstance(initargs);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isPresent() {
        return this.constructor != null;
    }
}

