/*
 * Decompiled with CFR 0.152.
 */
package meldexun.asmutil2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;

class SortedArrayList<E>
extends ArrayList<E> {
    private final Comparator<E> comparator;

    SortedArrayList(Comparator<E> comparator) {
        this.comparator = comparator;
    }

    static <T extends Comparable<T>> SortedArrayList<T> create() {
        return new SortedArrayList(Comparator.naturalOrder());
    }

    @Override
    public boolean add(E e) {
        super.add(this.insertIndex(e), e);
        return true;
    }

    private int insertIndex(E e) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            if (this.comparator.compare(this.get(mid), e) <= 0) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return low;
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        c.forEach(this::add);
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }
}

