/*
 * Decompiled with CFR 0.152.
 */
package meldexun.asmutil2;

import java.util.function.Consumer;
import java.util.function.Predicate;
import meldexun.asmutil2.ASMUtil;
import org.objectweb.asm.tree.ClassNode;

public interface ClassNodeTransformer
extends Comparable<ClassNodeTransformer> {
    public boolean transform(ClassNode var1);

    public int writeFlags();

    public int priority();

    @Override
    default public int compareTo(ClassNodeTransformer o) {
        return Integer.compare(this.priority(), o.priority());
    }

    public static ClassNodeTransformer create(int writeFlags, Consumer<ClassNode> transformer) {
        return ClassNodeTransformer.create(writeFlags, (ClassNode classNode) -> {
            if (!ASMUtil.DISABLE_LOGGING) {
                ASMUtil.LOGGER.info("Transforming class {}", (Object)classNode.name);
            }
            transformer.accept((ClassNode)classNode);
            return true;
        });
    }

    public static ClassNodeTransformer create(int writeFlags, Predicate<ClassNode> transformer) {
        return ClassNodeTransformer.create(writeFlags, 0, transformer);
    }

    public static ClassNodeTransformer create(final int writeFlags, final int priority, final Predicate<ClassNode> transformer) {
        return new ClassNodeTransformer(){

            @Override
            public boolean transform(ClassNode classNode) {
                if (!ASMUtil.DISABLE_LOGGING) {
                    ASMUtil.LOGGER.info("Transforming class {}", (Object)classNode.name);
                }
                return transformer.test(classNode);
            }

            @Override
            public int writeFlags() {
                return writeFlags;
            }

            @Override
            public int priority() {
                return priority;
            }
        };
    }
}

