/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.hook.minecraft.structurecleanup;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Objects;
import java.util.function.LongFunction;

class LazyLong2ObjectOpenHashMap<T>
extends Long2ObjectOpenHashMap<T> {
    LazyLong2ObjectOpenHashMap() {
    }

    T computeIfAbsent(long k, LongFunction<T> mappingFunction) {
        int pos;
        Objects.requireNonNull(mappingFunction);
        if (k == 0L) {
            if (this.containsNullKey) {
                return (T)this.value[this.n];
            }
            this.containsNullKey = true;
            pos = this.n;
        } else {
            long curr;
            pos = (int)HashCommon.mix((long)k) & this.mask;
            while ((curr = this.key[pos]) != 0L) {
                if (curr == k) {
                    return (T)this.value[pos];
                }
                pos = pos + 1 & this.mask;
            }
        }
        T v = mappingFunction.apply(k);
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize((int)(this.size + 1), (float)this.f));
        }
        return v;
    }
}

