/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.hook;

import com.charles445.rltweaker.util.CollisionUtil;
import com.charles445.rltweaker.util.WorldRadiusUtil;
import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import meldexun.reflectionutil.ReflectionField;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventBus;

public class HookWorld {
    private static final GetCollisionBoxesEvent EVENT = new GetCollisionBoxesEvent(null, null, null, null);
    private static final int EVENT_BUS_ID = new ReflectionField(EventBus.class, "busID", null).getInt(MinecraftForge.EVENT_BUS);

    @Deprecated
    public static List<Entity> getEntitiesWithinAABBExcludingEntity(World world, @Nullable Entity entityIn, AxisAlignedBB bb) {
        if (entityIn != null) {
            return WorldRadiusUtil.getEntitiesWithinAABBExcludingEntity(world, entityIn, bb, CollisionUtil.getRadiusForEntity(entityIn));
        }
        return world.func_72839_b(entityIn, bb);
    }

    public static List<Entity> getEntitiesInAABBexcluding(World world, @Nullable Entity entityIn, AxisAlignedBB boundingBox, @Nullable Predicate<? super Entity> predicate) {
        if (entityIn != null) {
            return WorldRadiusUtil.getEntitiesInAABBexcluding(world, entityIn, boundingBox, predicate, CollisionUtil.getRadiusForEntity(entityIn));
        }
        return world.func_175674_a(entityIn, boundingBox, predicate);
    }

    public static <T extends Entity> List<T> getEntitiesWithinAABB(World world, Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable Predicate<? super T> filter) {
        if (clazz.equals(EntityItem.class) || clazz.equals(EntityPlayer.class)) {
            return WorldRadiusUtil.getEntitiesWithinAABB(world, clazz, aabb, filter, 2.0);
        }
        return world.func_175647_a(clazz, aabb, filter);
    }

    private static boolean hasListeners() {
        return EVENT.getListenerList().getListeners(EVENT_BUS_ID).length > 0;
    }

    public static boolean getCollisionBoxes(World world, @Nullable Entity entity, AxisAlignedBB aabb, boolean p_191504_3_, @Nullable List<AxisAlignedBB> list) {
        if (p_191504_3_) {
            if (aabb.field_72340_a < -3.0E7 || aabb.field_72336_d > 3.0E7 || aabb.field_72339_c < -3.0E7 || aabb.field_72334_f > 3.0E7) {
                return true;
            }
            if (HookWorld.hasListeners()) {
                MinecraftForge.EVENT_BUS.post((Event)new GetCollisionBoxesEvent(world, entity, aabb, list));
                if (!list.isEmpty()) {
                    return true;
                }
            }
        } else if (entity != null && entity.func_174832_aS() == world.func_191503_g(entity)) {
            entity.func_174821_h(!entity.func_174832_aS());
        }
        int minX = MathHelper.func_76128_c((double)aabb.field_72340_a) - 1;
        int maxX = MathHelper.func_76128_c((double)aabb.field_72336_d) + 1;
        int minZ = MathHelper.func_76128_c((double)aabb.field_72339_c) - 1;
        int maxZ = MathHelper.func_76128_c((double)aabb.field_72334_f) + 1;
        int minY = Math.max(MathHelper.func_76128_c((double)aabb.field_72338_b) - 1, 0);
        int maxY = Math.min(MathHelper.func_76128_c((double)aabb.field_72337_e) + 1, 255);
        int minChunkX = minX >> 4;
        int maxChunkX = maxX >> 4;
        int minChunkZ = minZ >> 4;
        int maxChunkZ = maxZ >> 4;
        int minChunkY = minY >> 4;
        int maxChunkY = maxY >> 4;
        WorldBorder border = world.func_175723_af();
        boolean checkBorder = !p_191504_3_ && entity != null && !entity.func_174832_aS() && ((double)minX < border.func_177726_b() || (double)(maxX + 1) > border.func_177728_d() || (double)minZ < border.func_177736_c() || (double)(maxZ + 1) > border.func_177733_e());
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            int x0 = Math.max(minX, chunkX << 4);
            int x1 = Math.min(maxX, chunkX << 4 | 0xF);
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                Chunk chunk = world.func_72863_F().func_186026_b(chunkX, chunkZ);
                if (chunk == null) continue;
                int z0 = Math.max(minZ, chunkZ << 4);
                int z1 = Math.min(maxZ, chunkZ << 4 | 0xF);
                for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
                    ExtendedBlockStorage section = chunk.func_76587_i()[chunkY];
                    if (section == null) continue;
                    int y0 = Math.max(minY, chunkY << 4);
                    int y1 = Math.min(maxY, chunkY << 4 | 0xF);
                    for (int x = x0; x <= x1; ++x) {
                        boolean xBorder = x == minX || x == maxX;
                        for (int z = z0; z <= z1; ++z) {
                            boolean zBorder;
                            boolean bl = zBorder = z == minZ || z == maxZ;
                            if (xBorder && zBorder) continue;
                            for (int y = y0; y <= y1; ++y) {
                                if (!(!xBorder && !zBorder || y != minY && y != maxY)) continue;
                                pos.func_181079_c(x, y, z);
                                IBlockState state = checkBorder && !border.func_177746_a((BlockPos)pos) ? Blocks.field_150348_b.func_176223_P() : section.func_177485_a(x & 0xF, y & 0xF, z & 0xF);
                                state.func_185908_a(world, (BlockPos)pos, aabb, list, entity, false);
                                if (!p_191504_3_ || list.isEmpty()) continue;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return !list.isEmpty();
    }
}

