/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.hook;

import net.minecraft.block.Block;
import net.minecraft.block.BlockIce;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.BiomeConfig;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.init.ModConfig;

public class HookSereneSeasons {
    private static boolean isDimensionWhitelisted = false;
    private static Season.SubSeason subSeason = Season.SubSeason.EARLY_SPRING;

    public static void head_WorldServer_updateBlocks(World world) {
        isDimensionWhitelisted = SeasonsConfig.isDimensionWhitelisted((int)world.field_73011_w.getDimension());
        subSeason = SeasonHelper.getSeasonState((World)world).getSubSeason();
        if (ModConfig.seasons.changeWeatherFrequency) {
            switch (subSeason.getSeason()) {
                case WINTER: {
                    if (world.func_72912_H().func_76061_m()) {
                        world.func_72912_H().func_76069_a(false);
                    }
                    if (world.func_72912_H().func_76059_o() || world.func_72912_H().func_76083_p() <= 36000) break;
                    world.func_72912_H().func_76080_g(world.field_73012_v.nextInt(24000) + 12000);
                    break;
                }
                case SPRING: {
                    if (world.func_72912_H().func_76059_o() || world.func_72912_H().func_76083_p() <= 96000) break;
                    world.func_72912_H().func_76080_g(world.field_73012_v.nextInt(84000) + 12000);
                    break;
                }
                case SUMMER: {
                    if (world.func_72912_H().func_76061_m() || world.func_72912_H().func_76071_n() <= 36000) break;
                    world.func_72912_H().func_76090_f(world.field_73012_v.nextInt(24000) + 12000);
                    break;
                }
            }
        }
    }

    public static void post_Chunk_onTick(Chunk chunk) {
        int chance;
        if (!ModConfig.seasons.generateSnowAndIce) {
            return;
        }
        if (!isDimensionWhitelisted) {
            return;
        }
        if (subSeason.getSeason() == Season.WINTER) {
            return;
        }
        World world = chunk.func_177412_p();
        switch (subSeason) {
            case EARLY_SPRING: {
                chance = 16;
                break;
            }
            case MID_SPRING: {
                chance = 12;
                break;
            }
            case LATE_SPRING: {
                chance = 8;
                break;
            }
            default: {
                chance = 4;
            }
        }
        if (world.field_73012_v.nextInt(chance) != 0) {
            return;
        }
        BlockPos.MutableBlockPos pos = HookSereneSeasons.randomInChunk(world, chunk);
        int precipitationHeight = chunk.func_177440_h((BlockPos)pos).func_177956_o();
        pos.func_185336_p(precipitationHeight);
        Biome biome = chunk.func_177411_a((BlockPos)pos, world.func_72959_q());
        if (!BiomeConfig.enablesSeasonalEffects((Biome)biome)) {
            return;
        }
        while (pos.func_177956_o() >= 0) {
            Block block = chunk.func_177435_g((BlockPos)pos).func_177230_c();
            if (block == Blocks.field_150431_aC && HookSereneSeasons.getTemperature(biome, (BlockPos)pos) >= 0.15f) {
                world.func_175698_g((BlockPos)pos);
                break;
            }
            if (pos.func_177956_o() != precipitationHeight && block == Blocks.field_150432_aD && HookSereneSeasons.getTemperature(biome, (BlockPos)pos) >= 0.15f) {
                ((BlockIce)Blocks.field_150432_aD).func_185679_b(world, (BlockPos)pos);
                break;
            }
            pos.func_185336_p(pos.func_177956_o() - 1);
        }
    }

    private static BlockPos.MutableBlockPos randomInChunk(World world, Chunk chunk) {
        world.field_73005_l = world.field_73005_l * 3 + 1013904223;
        int offset = world.field_73005_l >> 2;
        return new BlockPos.MutableBlockPos((chunk.field_76635_g << 4) + (offset & 0xF), 0, (chunk.field_76647_h << 4) + (offset >> 8 & 0xF));
    }

    private static float getTemperature(Biome biome, BlockPos pos) {
        float baseTemp = biome.func_180626_a(pos);
        if (biome.func_185353_n() > 0.8f) {
            return baseTemp;
        }
        if (BiomeConfig.usesTropicalSeasons((Biome)biome)) {
            return baseTemp;
        }
        switch (subSeason) {
            case LATE_SPRING: 
            case EARLY_AUTUMN: {
                return baseTemp - 0.1f;
            }
            case MID_SPRING: 
            case MID_AUTUMN: {
                return baseTemp - 0.2f;
            }
            case EARLY_SPRING: 
            case LATE_AUTUMN: {
                return baseTemp - 0.4f;
            }
        }
        return baseTemp;
    }
}

