/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.hook;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.debug.DebugUtil;
import com.charles445.rltweaker.hook.NullableChunkCache;
import com.charles445.rltweaker.hook.minecraft.structurecleanup.StructureCleanupMode;
import com.charles445.rltweaker.util.ErrorUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEffect;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class HookMinecraft {
    public static Set<UUID> rotationErrors = new HashSet<UUID>();
    public static Set<UUID> motionErrors = new HashSet<UUID>();

    public static <E> ConcurrentLinkedDeque<E> newConcurrentLinkedDeque() {
        return new ConcurrentLinkedDeque();
    }

    public static PathNodeType verifyPathNodeType(PathNodeType type, IBlockAccess access, int x, int y, int z) {
        BlockPos basePos;
        IBlockState baseState;
        Block baseBlock;
        boolean isBaseIron;
        boolean isBaseWood = type == PathNodeType.DOOR_WOOD_CLOSED;
        boolean bl = isBaseIron = type == PathNodeType.DOOR_IRON_CLOSED;
        if ((isBaseWood || isBaseIron) && (baseBlock = (baseState = access.func_180495_p(basePos = new BlockPos(x, y, z))).func_177230_c()) instanceof BlockDoor && baseState.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            Material refMaterial = isBaseWood ? Material.field_151575_d : Material.field_151573_f;
            BlockPos downPos = basePos.func_177977_b();
            IBlockState downState = access.func_180495_p(downPos);
            Block downBlock = downState.func_177230_c();
            Material downMaterial = downState.func_185904_a();
            if (downBlock instanceof BlockDoor && downMaterial == refMaterial && ((Boolean)downState.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_OPEN;
            }
        }
        return type;
    }

    public static void playLimitedBroadcastSound(PlayerList playerList, SPacketEffect packet, BlockPos pos) {
        double maxDist = ModConfig.server.minecraft.broadcastedSoundsDistanceLimit;
        maxDist *= maxDist;
        for (EntityPlayerMP player : playerList.func_181057_v()) {
            if (!(player.func_174818_b(pos) < maxDist)) continue;
            player.field_71135_a.func_147359_a((Packet)packet);
        }
    }

    public static void aggressiveMotionCheck(Entity entity) {
        if (!ModConfig.server.minecraft.motionChecker) {
            return;
        }
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return;
        }
        if (HookMinecraft.testMotion(entity.field_70159_w, entity)) {
            entity.field_70159_w = 0.0;
            entity.field_70133_I = true;
        }
        if (HookMinecraft.testMotion(entity.field_70181_x, entity)) {
            entity.field_70181_x = 0.0;
            entity.field_70133_I = true;
        }
        if (HookMinecraft.testMotion(entity.field_70179_y, entity)) {
            entity.field_70179_y = 0.0;
            entity.field_70133_I = true;
        }
        if (HookMinecraft.testAngle(entity.field_70125_A, entity)) {
            entity.field_70125_A = 0.0f;
            entity.field_70177_z = 0.0f;
        } else if (HookMinecraft.testAngle(entity.field_70177_z, entity)) {
            entity.field_70125_A = 0.0f;
            entity.field_70177_z = 0.0f;
        }
    }

    private static boolean testAngle(float angle, Entity entity) {
        if (!Float.isFinite(angle)) {
            if (!rotationErrors.contains(entity.func_110124_au())) {
                rotationErrors.add(entity.func_110124_au());
                RLTweaker.logger.error("Entity has bad rotation! (aggressive) " + angle + " " + HookMinecraft.dumpEntity(entity));
                ErrorUtil.logSilent("Motion Checker Angle (aggressive)");
                if (ModConfig.server.minecraft.debug) {
                    DebugUtil.messageAll("Entity has bad angles! (aggressive) " + angle);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean testMotion(double motion, Entity entity) {
        if (motion > ModConfig.server.minecraft.motionCheckerSpeedCap || motion < -ModConfig.server.minecraft.motionCheckerSpeedCap || !Double.isFinite(motion)) {
            if (!motionErrors.contains(entity.func_110124_au())) {
                motionErrors.add(entity.func_110124_au());
                RLTweaker.logger.error("Entity moving too fast! (aggressive) " + motion + " " + HookMinecraft.dumpEntity(entity));
                ErrorUtil.logSilent("Motion Checker Speed (aggressive)");
                if (ModConfig.server.minecraft.debug) {
                    DebugUtil.messageAll("Entity moving too fast! (aggressive) " + motion);
                }
            }
            return true;
        }
        return false;
    }

    private static String dumpEntity(Entity entity) {
        StringBuilder sb = new StringBuilder();
        sb.append(entity.getClass().getName());
        sb.append(" - ");
        sb.append(entity.field_70165_t);
        sb.append(" ");
        sb.append(entity.field_70163_u);
        sb.append(" ");
        sb.append(entity.field_70161_v);
        sb.append(" ");
        sb.append(entity.field_70159_w);
        sb.append(" ");
        sb.append(entity.field_70181_x);
        sb.append(" ");
        sb.append(entity.field_70179_y);
        if (entity instanceof EntityLivingBase) {
            sb.append(" hurt time:");
            sb.append(((EntityLivingBase)entity).field_70737_aN);
        }
        sb.append(" dead:");
        sb.append(entity.field_70128_L);
        sb.append(" pitch:");
        sb.append(entity.field_70125_A);
        sb.append(" yaw:");
        sb.append(entity.field_70177_z);
        if (entity instanceof EntityLiving) {
            EntityLivingBase attack;
            EntityLivingBase revenge;
            EntityLiving living = (EntityLiving)entity;
            DamageSource damagesource = living.func_189748_bU();
            if (damagesource != null) {
                sb.append(" damagesource class:");
                sb.append(damagesource.getClass().getName());
            }
            if ((revenge = living.func_70643_av()) != null) {
                sb.append(" revenge target class:");
                sb.append(revenge.getClass().getName());
            }
            if ((attack = living.func_70638_az()) != null) {
                sb.append(" attack target class:");
                sb.append(attack.getClass().getName());
            }
        }
        return sb.toString();
    }

    public static boolean shouldEntityDestroyBlock(Block block, IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        String regname = block.getRegistryName().toString();
        for (String protectedBlock : ModConfig.server.minecraft.entityBlockDestroyBlacklist) {
            if (!regname.equals(protectedBlock)) continue;
            return false;
        }
        return true;
    }

    public static void clearItemFrame(EntityItemFrame frame) {
        frame.func_82334_a(ItemStack.field_190927_a);
    }

    public static EnumPushReaction hookPushReaction(Entity entity) {
        if (entity == null) {
            return EnumPushReaction.NORMAL;
        }
        ResourceLocation rl = EntityList.func_191301_a((Entity)entity);
        if (rl == null) {
            return EnumPushReaction.NORMAL;
        }
        String rls = rl.toString();
        for (String protectedEntity : ModConfig.server.minecraft.entityPushPrevention) {
            if (!rls.equals(protectedEntity)) continue;
            return EnumPushReaction.IGNORE;
        }
        return EnumPushReaction.NORMAL;
    }

    public static int overlayTextYOffset(int old) {
        return old + ModConfig.client.minecraft.overlayTextOffset;
    }

    public static boolean overlayTextDropShadow() {
        return ModConfig.client.minecraft.overlayTextDropShadow;
    }

    public static void clearAnvilResult(ContainerRepair container, IInventory outputSlot) {
        if (outputSlot != null) {
            outputSlot.func_70299_a(0, ItemStack.field_190927_a);
        }
        if (container != null) {
            container.field_82854_e = 0;
        }
    }

    public static IInventory hopperInventoryAtPosition(World world, BlockPos pos, Block block, IBlockState state, IInventory inventory) {
        if (inventory == null) {
            return null;
        }
        String regname = block.getRegistryName().toString();
        for (String protectedBlock : ModConfig.server.minecraft.hopperBlockBlacklist) {
            if (!regname.equals(protectedBlock)) continue;
            return null;
        }
        return inventory;
    }

    public static Pair<IItemHandler, Object> hopperItemHandler(World world, BlockPos pos, Block block, IBlockState state, Pair<IItemHandler, Object> destination) {
        if (destination == null) {
            return null;
        }
        String regname = block.getRegistryName().toString();
        for (String protectedBlock : ModConfig.server.minecraft.hopperBlockBlacklist) {
            if (!regname.equals(protectedBlock)) continue;
            return null;
        }
        return destination;
    }

    @Nullable
    public static Chunk cacheGetChunkFromChunkCoords(World world, int chunkX, int chunkZ, ChunkCache chunkCache) {
        if (chunkCache instanceof NullableChunkCache) {
            if (world.func_175667_e(new BlockPos(chunkX << 4, 64, chunkZ << 4))) {
                return world.func_72964_e(chunkX, chunkZ);
            }
            return null;
        }
        return world.func_72964_e(chunkX, chunkZ);
    }

    public static void preSaveWorld(WorldServer world) {
        MapStorage mapStorage = world.getPerWorldStorage();
        Stream.of(ModConfig.server.minecraft.cleanupStructureWorldgenFilesStructures).map(structureName -> mapStorage.func_75742_a(MapGenStructureData.class, structureName)).map(MapGenStructureData.class::cast).filter(Objects::nonNull).filter(structureData -> ModConfig.server.minecraft.cleanupStructureWorldgenFilesMode.clean(world, (MapGenStructureData)structureData)).forEach(WorldSavedData::func_76185_a);
        StructureCleanupMode.clearCache();
    }
}

