/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.config;

import com.charles445.rltweaker.hook.minecraft.structurecleanup.StructureCleanupMode;
import net.minecraftforge.common.config.Config;

public class ConfigMinecraft {
    @Config.Comment(value={"Debug mode, sends messages to all players and otherwise spams, do not enable unless you are privately testing!"})
    @Config.Name(value="Debug Mode")
    public boolean debug = false;
    @Config.Comment(value={"Aggressively checks for invalid living entity movement and attempts to fix it"})
    @Config.Name(value="Motion Checker")
    public boolean motionChecker = true;
    @Config.Comment(value={"Speed cap for the motion checker, living entities are not allowed to move faster than this"})
    @Config.Name(value="Motion Checker Speed Cap")
    @Config.RangeDouble(min=1.0)
    public double motionCheckerSpeedCap = 96.0;
    @Config.Comment(value={"Synchronizes dismounts with players more aggressively"})
    @Config.Name(value="Player Dismount Sync")
    public boolean playerDismountSync = true;
    @Config.Comment(value={"Synchronizes arrows with players more aggressively"})
    @Config.Name(value="Player Arrow Sync")
    public boolean playerArrowSync = true;
    @Config.Comment(value={"Removes some blacksmith chest loot to match TAN"})
    @Config.Name(value="Blacksmith Chest Tweak")
    public boolean blacksmithChestTweak = false;
    @Config.Comment(value={"In Minecraft 1.2.5, players who get knocked back have their camera tilted in the direction of the attack."})
    @Config.Name(value="Damage Tilt Effect")
    public boolean damageTilt = false;
    @Config.Comment(value={"Cleans up structure .dat files regularly to lower RAM usage. May break mods that use this data. (Stronghold, Village, Mineshaft, Temple, Monument, Mansion, Fortress, EndCity)"})
    @Config.Name(value="Cleanup Structure Worldgen Files Structures")
    public String[] cleanupStructureWorldgenFilesStructures = new String[]{"Village", "Mineshaft"};
    @Config.Comment(value={"ALWAYS: All structures get always deleted", "ALWAYS_COMPONENTS_ONLY: All components get always deleted", "GENERATED: Structures that are fully generated get deleted", "GENERATED_COMPONENTS: Components that are fully generated and structures that have no components get deleted", "GENERATED_COMPONENTS_ONLY: Components that are fully generated get deleted", "DISABLED: Nothing gets deleted"})
    @Config.Name(value="Cleanup Structure Worldgen Files Mode")
    public StructureCleanupMode cleanupStructureWorldgenFilesMode = StructureCleanupMode.GENERATED_COMPONENTS_ONLY;
    @Config.Comment(value={"Structure (or structure component) bounding boxes larger than this value on one axis will be ignored."})
    @Config.Name(value="Cleanup Structure Worldgen Files Size Limit")
    public int cleanupStructureWorldgenFilesSizeLimit = 4096;
    @Config.Comment(value={"Replace thrown witch potions with configured potions"})
    @Config.Name(value="Witch Potion Replacements")
    public boolean witchPotionReplacements = false;
    @Config.Comment(value={"Replace thrown witch harming potions with configured potions"})
    @Config.Name(value="Witch Potion Replacements - Harming")
    public String[] witchHarmingReplacements = new String[]{"minecraft:harming"};
    @Config.Comment(value={"Replace thrown witch slowness potions with configured potions"})
    @Config.Name(value="Witch Potion Replacements - Slowness")
    public String[] witchSlownessReplacements = new String[]{"minecraft:slowness"};
    @Config.Comment(value={"Replace thrown witch poison potions with configured potions"})
    @Config.Name(value="Witch Potion Replacements - Poison")
    public String[] witchPoisonReplacements = new String[]{"minecraft:poison"};
    @Config.Comment(value={"Replace thrown witch weakness potions with configured potions"})
    @Config.Name(value="Witch Potion Replacements - Weakness")
    public String[] witchWeaknessReplacements = new String[]{"minecraft:weakness"};
    @Config.Comment(value={"Allows all zombies to break doors"})
    @Config.Name(value="All Zombies Break Doors")
    public boolean allZombiesBreakDoors = false;
    @Config.Comment(value={"Distance in chunks lightning can be heard by a player. Default setting disables this tweak"})
    @Config.Name(value="Lightning Sound Chunk Distance")
    @Config.RangeDouble(min=2.0, max=3000000.0)
    public double lightningSoundChunkDistance = 10000.0;
    @Config.Comment(value={"REQUIRES Patch patchBroadcastSounds. Globally broadcasted sounds are only sent to players this close by, in blocks. Ignores dimension."})
    @Config.Name(value="Broadcasted Sounds Distance Limit")
    @Config.RangeDouble(min=2.0, max=4.0E7)
    public double broadcastedSoundsDistanceLimit = 1000.0;
    @Config.Comment(value={"REQUIRES Patch patchEnchantments. Blacklisted enchantments do not show up as random enchantments. May still show up via other mods."})
    @Config.Name(value="Enchantment Blacklist")
    public String[] blacklistedEnchantments = new String[]{"examplemod:enchantment"};
    @Config.Comment(value={"Container class names to enforce player distance (to prevent dupes and other glitchy behavior). Must be the full qualified class name of the containers."})
    @Config.Name(value="Container Distance Classes")
    public String[] containerDistanceClasses = new String[]{"examplemod.container.ExampleContainer"};
    @Config.Comment(value={"REQUIRES patch patchEntityBlockDestroy. Prevents entities from destroying these blocks."})
    @Config.Name(value="Entity Block Destroy Blacklist")
    public String[] entityBlockDestroyBlacklist = new String[]{"examplemod:block"};
    @Config.Comment(value={"REQUIRES patch patchPushReaction. Prevents specified entities from being pushed by pistons."})
    @Config.Name(value="Entity Push Prevention")
    public String[] entityPushPrevention = new String[]{"examplemod:entity"};
    @Config.Comment(value={"REQUIRES patch patchHopper. Prevents hoppers from pulling from or inserting into specific blocks."})
    @Config.Name(value="Hopper Block Blacklist")
    public String[] hopperBlockBlacklist = new String[]{"examplemod:block"};
    @Config.Comment(value={"Whether lightning should destroy items"})
    @Config.Name(value="Lightning Destroys Items")
    public boolean lightningDestroysItems = true;
    @Config.Comment(value={"Enables watchdog related features"})
    @Config.Name(value="Watchdog")
    @Config.RequiresMcRestart
    public boolean watchdog = true;
    @Config.Comment(value={"Enables investigate AI for all entities defined in the 'investigateAI.json' file."})
    @Config.Name(value="Investigate AI")
    @Config.RequiresMcRestart
    public boolean investigateAi = false;
    @Config.Comment(value={"Enables investigate AI for non-player attacks. Might cause lags."})
    @Config.Name(value="Investigate non-player Attacks")
    public boolean investigateNonPlayerAttacks = false;
    @Config.Comment(value={"Fixes dupe when dropping items while disconnecting from a lagging server."})
    @Config.Name(value="Fix Drop Disconnect Lag Dupe")
    public boolean fixDropDisconnectLagDupe = true;
}

