/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.client.texture;

import com.charles445.rltweaker.client.texture.TextureData;
import com.charles445.rltweaker.client.texture.TextureDataUtil;
import de.keksuccino.fancymenu.menu.animation.ResourcePackAnimationRenderer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class AnimatedTexture
extends AbstractTexture {
    private final ResourcePackAnimationRenderer animation;
    private final Map<ResourceLocation, CompletableFuture<TextureData>> textureDataLoadTasks = new HashMap<ResourceLocation, CompletableFuture<TextureData>>();
    private ResourceLocation lastFrameTextureLocation;

    public AnimatedTexture(ResourcePackAnimationRenderer animation) {
        if (animation.getAnimationFrames().isEmpty()) {
            throw new IllegalArgumentException("Animation can't be empty");
        }
        this.animation = animation;
    }

    public void func_110551_a(IResourceManager resourceManager) throws IOException {
        this.func_147631_c();
        try (TextureData textureData = TextureDataUtil.loadTextureData((ResourceLocation)this.animation.getAnimationFrames().get(0));){
            int id = this.func_110552_b();
            TextureUtil.func_110991_a((int)id, (int)textureData.width, (int)textureData.height);
            TextureUtil.func_94277_a((int)id);
            TextureUtil.func_147951_b((boolean)textureData.blur);
            TextureUtil.func_110997_a((boolean)textureData.clamp);
        }
    }

    public void loadFrame() {
        ResourceLocation currentFrameTextureLocation = (ResourceLocation)this.animation.getAnimationFrames().get(this.animation.currentFrame());
        if (Objects.equals(currentFrameTextureLocation, this.lastFrameTextureLocation)) {
            return;
        }
        this.lastFrameTextureLocation = currentFrameTextureLocation;
        try (TextureData textureData = this.waitForOrLoadTextureData((ResourceLocation)this.animation.getAnimationFrames().get(this.animation.currentFrame()));){
            TextureUtil.func_94277_a((int)this.func_110552_b());
            GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)textureData.width, (int)textureData.height, (int)6408, (int)5121, (ByteBuffer)((ByteBuffer)textureData.buffer.getBuffer()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.preloadNextFrames();
    }

    private void preloadNextFrames() {
        int i = (this.animation.currentFrame() + 1) % this.animation.animationFrames();
        while (i != (this.animation.currentFrame() + 5) % this.animation.animationFrames() && i != this.animation.currentFrame()) {
            ResourceLocation textureLocation = (ResourceLocation)this.animation.getAnimationFrames().get(i);
            this.textureDataLoadTasks.computeIfAbsent(textureLocation, k -> CompletableFuture.supplyAsync(() -> {
                try {
                    return TextureDataUtil.loadTextureData(k);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
            i = (i + 1) % this.animation.animationFrames();
        }
    }

    private TextureData waitForOrLoadTextureData(ResourceLocation textureLocation) throws IOException {
        CompletableFuture<TextureData> textureData = this.textureDataLoadTasks.remove(textureLocation);
        if (textureData != null) {
            return textureData.join();
        }
        return TextureDataUtil.loadTextureData(textureLocation);
    }
}

