/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.asm.configloader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

class ConfigReader
implements AutoCloseable,
Iterable<String>,
Iterator<String> {
    private final BufferedReader reader;
    private String nextLine;
    private int lineNumber = -1;

    public ConfigReader(BufferedReader reader) {
        this.reader = reader;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public String readLine() throws IOException {
        String l;
        while ((l = this.reader.readLine()) != null) {
            ++this.lineNumber;
            if ((l = l.trim()).isEmpty() || l.startsWith("#")) continue;
            return l;
        }
        return null;
    }

    public int lineNumber() {
        return this.lineNumber;
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.nextLine != null) {
            return true;
        }
        try {
            this.nextLine = this.readLine();
            return this.nextLine != null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String next() {
        if (this.nextLine != null || this.hasNext()) {
            String line = this.nextLine;
            this.nextLine = null;
            return line;
        }
        throw new NoSuchElementException();
    }
}

