/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.compat;

import com.charles445.simpledifficulty.api.SDCompatibility;
import com.charles445.simpledifficulty.api.config.JsonConfig;
import com.charles445.simpledifficulty.api.config.json.JsonItemIdentity;
import com.charles445.simpledifficulty.api.config.json.JsonPropertyTemperature;
import com.charles445.simpledifficulty.api.config.json.JsonPropertyValue;
import com.charles445.simpledifficulty.util.CompatUtil;
import com.charles445.simpledifficulty.util.OreDictUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class JsonCompatDefaults {
    public static JsonCompatDefaults instance = new JsonCompatDefaults();

    public void populate() {
        this.populateBaubles();
        this.populateBiomesOPlenty();
        this.populateHarvestCraft();
        this.populateLycanitesMobs();
        this.populatePyrotech();
        this.populateRealisticTorches();
        this.populateRustic();
        this.populateSimpleCampfire();
        this.populateTinkersConstruct();
    }

    public boolean populate(String modid) {
        switch (modid) {
            case "baubles": {
                return this.populateBaubles();
            }
            case "biomesoplenty": {
                return this.populateBiomesOPlenty();
            }
            case "harvestcraft": {
                return this.populateHarvestCraft();
            }
            case "lycanitesmobs": {
                return this.populateLycanitesMobs();
            }
            case "pyrotech": {
                return this.populatePyrotech();
            }
            case "realistictorches": {
                return this.populateRealisticTorches();
            }
            case "rustic": {
                return this.populateRustic();
            }
            case "campfire": {
                return this.populateSimpleCampfire();
            }
            case "tconstruct": {
                return this.populateTinkersConstruct();
            }
        }
        return false;
    }

    private boolean populateBaubles() {
        if (!this.canUseModJsonDefaults("baubles")) {
            return false;
        }
        JsonConfig.registerArmorTemperature("baubles:ring", -0.25f);
        return true;
    }

    private boolean populateBiomesOPlenty() {
        if (!this.canUseModJsonDefaults("biomesoplenty")) {
            return false;
        }
        this.addFluidTemperature("hot_spring_water", 3.0f);
        return true;
    }

    private boolean populateHarvestCraft() {
        ResourceLocation loc;
        if (!this.canUseModJsonDefaults("harvestcraft")) {
            return false;
        }
        for (ItemStack stack : OreDictUtil.listAlljuice) {
            loc = stack.func_77973_b().getRegistryName();
            if (!loc.func_110624_b().equals("harvestcraft")) continue;
            this.addDrink(loc.toString(), 6, 5.0f);
        }
        for (ItemStack stack : OreDictUtil.listAllsoda) {
            loc = stack.func_77973_b().getRegistryName();
            if (!loc.func_110624_b().equals("harvestcraft")) continue;
            this.addDrink(loc.toString(), 9, 7.0f);
        }
        for (ItemStack stack : OreDictUtil.listAllsmoothie) {
            loc = stack.func_77973_b().getRegistryName();
            if (!loc.func_110624_b().equals("harvestcraft")) continue;
            this.addDrink(loc.toString(), 9, 7.0f);
        }
        this.addDrink("harvestcraft:teaitem", 6, 5.0f);
        this.addDrink("harvestcraft:coffeeitem", 6, 5.0f);
        this.addDrink("harvestcraft:hotchocolateitem", 6, 5.0f);
        this.addDrink("harvestcraft:lemonaideitem", 9, 7.0f);
        this.addDrink("harvestcraft:raspberryicedteaitem", 9, 7.0f);
        this.addDrink("harvestcraft:chaiteaitem", 9, 7.0f);
        this.addDrink("harvestcraft:espressoitem", 12, 9.0f);
        this.addDrink("harvestcraft:coffeeconlecheitem", 18, 15.0f);
        this.addDrink("harvestcraft:coconutmilkitem", 3, 3.0f);
        this.addDrink("harvestcraft:chocolatemilkitem", 6, 5.0f);
        this.addDrink("harvestcraft:fruitpunchitem", 6, 5.0f);
        this.addDrink("harvestcraft:pinacoladaitem", 6, 5.0f);
        this.addDrink("harvestcraft:eggnogitem", 15, 12.0f);
        this.addDrink("harvestcraft:soymilkitem", 3, 3.0f);
        this.addDrink("harvestcraft:applecideritem", 6, 5.0f);
        this.addDrink("harvestcraft:energydrinkitem", 15, 12.0f);
        this.addDrink("harvestcraft:greenteaitem", 6, 5.0f);
        this.addDrink("harvestcraft:earlgreyteaitem", 6, 5.0f);
        this.addDrink("harvestcraft:bubbleteaitem", 12, 9.0f);
        this.addDrink("harvestcraft:rosepetalteaitem", 6, 5.0f);
        this.addDrink("harvestcraft:cherryslushieitem", 9, 7.0f);
        this.addDrink("harvestcraft:lycheeteaitem", 9, 7.0f);
        this.addDrink("harvestcraft:dandelionteaitem", 9, 7.0f);
        this.addDrink("harvestcraft:raspberrymilkshakeitem", 15, 12.0f);
        this.addDrink("harvestcraft:pumpkinspicelatteitem", 20, 19.0f);
        this.addDrink("harvestcraft:rootbeerfloatitem", 18, 15.0f);
        this.addDrink("harvestcraft:hotcocoaitem", 15, 12.0f);
        this.addDrink("harvestcraft:strawberrymilkshakeitem", 9, 7.0f);
        this.addDrink("harvestcraft:chocolatemilkshakeitem", 9, 7.0f);
        this.addDrink("harvestcraft:bananamilkshakeitem", 9, 7.0f);
        this.addDrink("harvestcraft:gooseberrymilkshakeitem", 9, 7.0f);
        this.addDrink("harvestcraft:durianmilkshakeitem", 9, 7.0f);
        this.addDrink("harvestcraft:cookiesandmilkitem", 8, 7.0f);
        this.addDrink("harvestcraft:sundayhighteaitem", 12, 10.0f);
        this.addDrink("harvestcraft:delightedmealitem", 14, 13.0f);
        this.addDrink("harvestcraft:weekendpicnicitem", 20, 20.0f);
        this.addDrink("harvestcraft:theatreboxitem", 16, 15.0f);
        this.addDrink("harvestcraft:friedfeastitem", 20, 20.0f);
        this.addDrink("harvestcraft:bbqplatteritem", 20, 20.0f);
        for (int i = 1; i <= 16; ++i) {
            this.addHeldItemTemperature("harvestcraft:candledeco" + i, 1.0f);
            this.addBlockTemperature("harvestcraft:candledeco" + i, 1.0f, new JsonPropertyValue[0]);
        }
        return true;
    }

    private boolean populateLycanitesMobs() {
        if (!this.canUseModJsonDefaults("lycanitesmobs")) {
            return false;
        }
        this.addBlockTemperature("lycanitesmobs:purelava", 12.5f, new JsonPropertyValue[0]);
        this.addBlockTemperature("lycanitesmobs:moglava", 12.5f, new JsonPropertyValue[0]);
        this.addBlockTemperature("lycanitesmobs:ooze", -12.5f, new JsonPropertyValue[0]);
        this.addBlockTemperature("lycanitesmobs:rabbitooze", -12.5f, new JsonPropertyValue[0]);
        this.addBlockTemperature("lycanitesmobs:frostfire", -5.0f, new JsonPropertyValue[0]);
        this.addBlockTemperature("lycanitesmobs:icefire", -8.0f, new JsonPropertyValue[0]);
        return true;
    }

    private boolean populatePyrotech() {
        if (!this.canUseModJsonDefaults("pyrotech")) {
            return false;
        }
        this.addBlockTemperature("pyrotech:torch_fiber", 3.0f, new JsonPropertyValue("type", "LIT"));
        this.addBlockTemperature("pyrotech:torch_stone", 3.0f, new JsonPropertyValue("type", "LIT"));
        this.addBlockTemperature("pyrotech:campfire", 7.0f, new JsonPropertyValue("variant", "LIT"));
        this.addBlockTemperature("pyrotech:kiln_pit", 6.0f, new JsonPropertyValue("variant", "ACTIVE"));
        this.addBlockTemperature("pyrotech:bloomery", 6.0f, new JsonPropertyValue("type", "BottomLit"));
        this.addBlockTemperature("pyrotech:wither_forge", 7.0f, new JsonPropertyValue("type", "BottomLit"));
        this.addBlockTemperature("pyrotech:pile_slag", 4.0f, new JsonPropertyValue("molten", "true"));
        float pyrotechStone = 5.0f;
        float pyroTechBrick = 4.0f;
        this.addBlockTemperature("pyrotech:stone_kiln", pyrotechStone, new JsonPropertyValue("type", "BOTTOM_LIT"));
        this.addBlockTemperature("pyrotech:stone_oven", pyrotechStone, new JsonPropertyValue("type", "BOTTOM_LIT"));
        this.addBlockTemperature("pyrotech:stone_sawmill", pyrotechStone, new JsonPropertyValue("type", "BOTTOM_LIT"));
        this.addBlockTemperature("pyrotech:stone_crucible", pyrotechStone, new JsonPropertyValue("type", "BOTTOM_LIT"));
        this.addBlockTemperature("pyrotech:brick_kiln", pyroTechBrick, new JsonPropertyValue("type", "BOTTOM_LIT"));
        this.addBlockTemperature("pyrotech:brick_oven", pyroTechBrick, new JsonPropertyValue("type", "BOTTOM_LIT"));
        this.addBlockTemperature("pyrotech:brick_sawmill", pyroTechBrick, new JsonPropertyValue("type", "BOTTOM_LIT"));
        this.addBlockTemperature("pyrotech:brick_crucible", pyroTechBrick, new JsonPropertyValue("type", "BOTTOM_LIT"));
        return true;
    }

    private boolean populateRealisticTorches() {
        if (!this.canUseModJsonDefaults("realistictorches")) {
            return false;
        }
        this.addHeldItemTemperature("realistictorches:torch_lit", 1.0f);
        this.addBlockTemperature("realistictorches:torch_lit", 1.0f, new JsonPropertyValue[0]);
        return true;
    }

    private boolean populateRustic() {
        if (!this.canUseModJsonDefaults("rustic")) {
            return false;
        }
        this.addHeldItemTemperature("rustic:candle", 1.0f);
        this.addBlockTemperature("rustic:candle", 1.0f, new JsonPropertyValue[0]);
        this.addHeldItemTemperature("rustic:candle_gold", 1.0f);
        this.addBlockTemperature("rustic:candle_gold", 1.0f, new JsonPropertyValue[0]);
        int boozeThirst = 5;
        float boozeSaturation = 5.0f;
        float boozeSickness = 0.25f;
        int juiceThirst = 6;
        float juiceSaturation = 5.0f;
        this.addDrink("rustic:elixir", 4, 0.4f);
        this.addDrink("rustic:fluid_bottle", 2, 0.1f, 0.9f, this.rusticFluid("oliveoil"));
        this.addDrink("rustic:fluid_bottle", 2, 8.0f, this.rusticFluid("ironberryjuice"));
        this.addDrink("rustic:fluid_bottle", juiceThirst, juiceSaturation, this.rusticFluid("wildberryjuice"));
        this.addDrink("rustic:fluid_bottle", juiceThirst, juiceSaturation, this.rusticFluid("grapejuice"));
        this.addDrink("rustic:fluid_bottle", juiceThirst, juiceSaturation, this.rusticFluid("applejuice"));
        this.addDrink("rustic:fluid_bottle", boozeThirst, boozeSaturation, boozeSickness, this.rusticFluid("alewort"));
        this.addDrink("rustic:fluid_bottle", 4, 3.0f, this.rusticFluid("honey"));
        this.addDrink("rustic:fluid_bottle", boozeThirst, boozeSaturation, boozeSickness, this.rusticFluid("ale"));
        this.addDrink("rustic:fluid_bottle", boozeThirst, boozeSaturation, boozeSickness, this.rusticFluid("cider"));
        this.addDrink("rustic:fluid_bottle", boozeThirst, boozeSaturation, boozeSickness, this.rusticFluid("ironwine"));
        this.addDrink("rustic:fluid_bottle", boozeThirst, boozeSaturation, boozeSickness, this.rusticFluid("mead"));
        this.addDrink("rustic:fluid_bottle", boozeThirst, boozeSaturation, boozeSickness, this.rusticFluid("wildberrywine"));
        this.addDrink("rustic:fluid_bottle", boozeThirst, boozeSaturation, boozeSickness, this.rusticFluid("wine"));
        return true;
    }

    private String rusticFluid(String name) {
        return "{Fluid:{FluidName:\"" + name + "\"}}";
    }

    private boolean populateSimpleCampfire() {
        if (!this.canUseModJsonDefaults("campfire")) {
            return false;
        }
        this.addBlockTemperature("campfire:campfire", 7.0f, new JsonPropertyValue[0]);
        return true;
    }

    private boolean populateTinkersConstruct() {
        if (!this.canUseModJsonDefaults("tconstruct")) {
            return false;
        }
        float moltenTemp = 12.5f;
        this.addBlockTemperature("tconstruct:molten_alubrass", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_aluminum", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_ardite", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_brass", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_bronze", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_clay", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_cobalt", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_copper", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_dirt", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_electrum", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_emerald", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_glass", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_gold", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_iron", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_knightslime", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_lead", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_manyullyn", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_nickel", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_obsidian", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_pigiron", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_silver", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_steel", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_stone", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_tin", moltenTemp, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:molten_zinc", moltenTemp, new JsonPropertyValue[0]);
        float lavawood = 5.0f;
        float firewood = 7.0f;
        this.addBlockTemperature("tconstruct:firewood", lavawood, new JsonPropertyValue("type", "LAVAWOOD"));
        this.addBlockTemperature("tconstruct:firewood", firewood, new JsonPropertyValue("type", "FIREWOOD"));
        this.addBlockTemperature("tconstruct:firewood_stairs", firewood, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:lavawood_stairs", lavawood, new JsonPropertyValue[0]);
        this.addBlockTemperature("tconstruct:firewood_slab", lavawood, new JsonPropertyValue("type", "LAVAWOOD"));
        this.addBlockTemperature("tconstruct:firewood_slab", firewood, new JsonPropertyValue("type", "FIREWOOD"));
        float heldWood = 2.0f;
        this.addHeldItemTemperature("tconstruct:firewood", 0, heldWood);
        this.addHeldItemTemperature("tconstruct:firewood", 1, heldWood);
        this.addHeldItemTemperature("tconstruct:firewood_stairs", 0, heldWood);
        this.addHeldItemTemperature("tconstruct:lavawood_stairs", 0, heldWood);
        this.addHeldItemTemperature("tconstruct:firewood_slab", 0, heldWood);
        this.addHeldItemTemperature("tconstruct:firewood_slab", 1, heldWood);
        this.addHeldItemTemperature("tconstruct:stone_torch", 0, 1.0f);
        return true;
    }

    private void addBlockTemperature(String registryName, float temperature, JsonPropertyValue ... properties) {
        JsonConfig.registerBlockTemperature(registryName, temperature, properties);
    }

    private void addDrink(String registryName, int amount, float saturation) {
        this.addDrink(registryName, amount, saturation, 0.0f);
    }

    private void addDrink(String registryName, int amount, float saturation, float thirstyChance) {
        JsonConfig.registerConsumableThirst(registryName, amount, saturation, thirstyChance, new JsonItemIdentity(-1));
    }

    private void addDrink(String registryName, int amount, float saturation, String nbt) {
        JsonConfig.registerConsumableThirst(registryName, amount, saturation, 0.0f, new JsonItemIdentity(-1, nbt));
    }

    private void addDrink(String registryName, int amount, float saturation, float thirstyChance, String nbt) {
        JsonConfig.registerConsumableThirst(registryName, amount, saturation, thirstyChance, new JsonItemIdentity(-1, nbt));
    }

    private void addFluidTemperature(String fluidName, float temperature) {
        JsonConfig.registerFluidTemperature(fluidName, temperature);
    }

    private void addHeldItemTemperature(String registryName, float temperature) {
        JsonConfig.registerHeldItem(registryName, temperature, new JsonItemIdentity(-1));
    }

    private void addHeldItemTemperature(String registryName, int metadata, float temperature) {
        JsonConfig.registerHeldItem(registryName, temperature, new JsonItemIdentity(metadata));
    }

    private boolean canUseModJsonDefaults(String modid) {
        return this.canUseModJsonDefaults(modid, true);
    }

    private boolean canUseModJsonDefaults(String modid, boolean modBool) {
        return modBool && CompatUtil.canUseMod(modid) && !SDCompatibility.disabledDefaultJson.contains(modid);
    }

    private JsonPropertyTemperature propTemp(float temp) {
        return new JsonPropertyTemperature(temp, new JsonPropertyValue[0]);
    }

    private JsonPropertyTemperature propTemp(float temp, JsonPropertyValue ... props) {
        return new JsonPropertyTemperature(temp, props);
    }
}

