/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.client.gui;

import com.charles445.simpledifficulty.api.SDCapabilities;
import com.charles445.simpledifficulty.api.SDCompatibility;
import com.charles445.simpledifficulty.api.SDPotions;
import com.charles445.simpledifficulty.api.config.QuickConfig;
import com.charles445.simpledifficulty.api.thirst.IThirstCapability;
import com.charles445.simpledifficulty.config.ModConfig;
import com.charles445.simpledifficulty.util.RenderUtil;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ThirstGui {
    private final Minecraft minecraftInstance = Minecraft.func_71410_x();
    private int updateCounter = 0;
    private final Random rand = new Random();
    public static final ResourceLocation ICONS = new ResourceLocation("simpledifficulty:textures/gui/icons.png");
    public static final ResourceLocation THIRSTHUD = new ResourceLocation("simpledifficulty:textures/gui/thirsthud.png");
    private static final int texturepos_X = 0;
    private static final int texturepos_Y = 0;
    private static final int textureWidth = 9;
    private static final int textureHeight = 9;

    @SubscribeEvent
    public void onPreRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.AIR && QuickConfig.isThirstEnabled() && SDCompatibility.defaultThirstDisplay) {
            this.rand.setSeed(this.updateCounter * 445);
            boolean classic = ModConfig.client.classicHUDThirst;
            if (classic) {
                this.bind(ICONS);
            } else {
                this.bind(THIRSTHUD);
            }
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            IThirstCapability capability = SDCapabilities.getThirstData((EntityPlayer)player);
            ScaledResolution resolution = event.getResolution();
            this.renderThirst(resolution.func_78326_a(), resolution.func_78328_b(), capability.getThirstLevel(), capability.getThirstSaturation());
            this.bind(Gui.field_110324_m);
            GuiIngameForge.right_height += 10;
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !this.minecraftInstance.func_147113_T()) {
            ++this.updateCounter;
        }
    }

    private void renderThirst(int width, int height, int thirst, float thirstSaturation) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        int left = width / 2 + 82;
        int top = height - GuiIngameForge.right_height;
        for (int i = 0; i < 10; ++i) {
            int halfIcon = i * 2 + 1;
            int x = left - i * 8;
            int y = top;
            int bgXOffset = 0;
            int xOffset = 0;
            if (Minecraft.func_71410_x().field_71439_g.func_70644_a(SDPotions.thirsty)) {
                xOffset += 36;
                bgXOffset = 117;
            }
            if (thirstSaturation <= 0.0f && this.updateCounter % (thirst * 3 + 1) == 0) {
                y = top + (this.rand.nextInt(3) - 1);
            }
            RenderUtil.drawTexturedModalRect(x, y, 0 + bgXOffset, 0, 9, 9);
            if (halfIcon < thirst) {
                RenderUtil.drawTexturedModalRect(x, y, 0 + xOffset + 36, 0, 9, 9);
                continue;
            }
            if (halfIcon != thirst) continue;
            RenderUtil.drawTexturedModalRect(x, y, 0 + xOffset + 45, 0, 9, 9);
        }
        int thirstSaturationInt = (int)thirstSaturation;
        if (thirstSaturationInt > 0 && ModConfig.client.drawThirstSaturation) {
            for (int i = 0; i < 10; ++i) {
                int halfIcon = i * 2 + 1;
                int x = left - i * 8;
                int y = top;
                if (halfIcon < thirstSaturationInt) {
                    RenderUtil.drawTexturedModalRect(x, y, 126, 0, 9, 9);
                    continue;
                }
                if (halfIcon != thirstSaturationInt) continue;
                RenderUtil.drawTexturedModalRect(x, y, 135, 0, 9, 9);
            }
        }
        GlStateManager.func_179084_k();
    }

    private void bind(ResourceLocation resource) {
        this.minecraftInstance.func_110434_K().func_110577_a(resource);
    }
}

