/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.block;

import com.charles445.simpledifficulty.api.SDBlocks;
import com.charles445.simpledifficulty.tileentity.TileEntitySpit;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSpit
extends BlockContainer {
    private static final AxisAlignedBB HITBOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);

    public BlockSpit() {
        super(Material.field_151575_d, MapColor.field_151663_o);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149675_a(true);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySpit();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntitySpit) {
            ((TileEntitySpit)te).handleRightClick(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
        }
        return true;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.checkCampfireOrDestroy(world, pos, state);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return this.hasCampfire(world, pos) && super.func_176196_c(world, pos);
    }

    public void observedNeighborChange(IBlockState observerState, World world, BlockPos observerPos, Block changedBlock, BlockPos changedBlockPos) {
        super.observedNeighborChange(observerState, world, observerPos, changedBlock, changedBlockPos);
        this.checkCampfireOrDestroy(world, observerPos, observerState);
    }

    public boolean hasCampfire(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() == SDBlocks.campfire;
    }

    public void checkCampfireOrDestroy(World world, BlockPos pos, IBlockState state) {
        if (!this.hasCampfire(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntitySpit) {
            ((TileEntitySpit)te).dumpItems(world, pos);
            ((TileEntitySpit)te).dumpExperience(world, pos);
        }
        super.func_180663_b(world, pos, state);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return HITBOX;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return Block.field_185506_k;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

