/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.block;

import com.charles445.simpledifficulty.api.SDBlocks;
import com.charles445.simpledifficulty.block.IBlockStateIgnore;
import com.charles445.simpledifficulty.config.ModConfig;
import com.charles445.simpledifficulty.util.OreDictUtil;
import com.charles445.simpledifficulty.util.SoundUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCampfire
extends Block
implements IBlockStateIgnore {
    private static final int AGE_MIN = 0;
    private static final int AGE_MAX = 7;
    private static final int LOG_REFUEL = 3;
    private static final int TICK_RATE = 10;
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    public static final PropertyBool BURNING = PropertyBool.func_177716_a((String)"burning");
    private static final IProperty[] ignoredProperties = new IProperty[]{BURNING};
    private static final AxisAlignedBB HITBOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.4, 1.0);

    public BlockCampfire() {
        super(Material.field_151594_q, MapColor.field_151663_o);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149675_a(true);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItemStack = player.func_184586_b(hand);
        if (heldItemStack.func_190926_b()) {
            return true;
        }
        Item heldItem = heldItemStack.func_77973_b();
        if (Block.func_149634_a((Item)heldItem).equals(SDBlocks.spit)) {
            return false;
        }
        if (world.field_72995_K) {
            if (heldItem == Items.field_151033_d) {
                int age = (Integer)state.func_177229_b((IProperty)AGE);
                boolean burning = (Boolean)state.func_177229_b((IProperty)BURNING);
                if (!burning && age < 7 && !world.func_175727_C(pos.func_177984_a())) {
                    world.func_184133_a(player, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                }
            }
            return true;
        }
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        boolean burning = (Boolean)state.func_177229_b((IProperty)BURNING);
        if (OreDictUtil.isOre(OreDictUtil.logWood, heldItemStack)) {
            if (age > 0) {
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItemStack.func_190918_g(1);
                }
                int refuelAmount = 3 + (age == 7 ? 1 : 0);
                world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(Math.max(0, age - refuelAmount))), 2);
            }
            return true;
        }
        if (!burning && age < 7 && !world.func_175727_C(pos.func_177984_a())) {
            if (OreDictUtil.isOre(OreDictUtil.stick, heldItemStack) || heldItem == Items.field_151055_y) {
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItemStack.func_190918_g(1);
                }
                if (world.field_73012_v.nextInt(ModConfig.server.miscellaneous.campfireStickIgniteChance) == 0) {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(true)), 2);
                }
                return true;
            }
            if (heldItem == Items.field_151033_d) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(true)), 2);
                heldItemStack.func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
        }
        return true;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        boolean burning = (Boolean)state.func_177229_b((IProperty)BURNING);
        if (burning) {
            if (world.func_175727_C(pos.func_177984_a())) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false)), 2);
                this.effectExtinguish(world, pos);
            } else if (rand.nextInt(ModConfig.server.miscellaneous.campfireDecayChance) == 0) {
                if (++age >= 7) {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(7)).func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false)), 2);
                    this.effectExtinguish(world, pos);
                } else {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age)), 2);
                }
            }
        }
    }

    public int func_149738_a(World world) {
        return 10;
    }

    public IBlockState func_176203_a(int meta) {
        boolean burning = (meta & 1) != 0;
        int age = meta >> 1;
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age)).func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(burning));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE) << 1 | ((Boolean)state.func_177229_b((IProperty)BURNING) != false ? 1 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, BURNING});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return HITBOX;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return Block.field_185506_k;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue() && entity instanceof EntityLivingBase) {
            entity.func_70015_d(1);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        if (((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue()) {
            int age = (Integer)state.func_177229_b((IProperty)AGE);
            float strength = 1.0f - (float)age / 7.0f;
            if (rand.nextFloat() < strength) {
                int loop = rand.nextInt(6) + 1;
                for (int i = 0; i < loop; ++i) {
                    this.createFlameParticle(world, pos, rand);
                }
            }
            if (rand.nextInt(30) == 0) {
                world.func_184134_a(0.5 + (double)pos.func_177958_n(), 0.5 + (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p(), SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 0.5f, 1.0f, false);
            }
        }
    }

    private void effectExtinguish(World world, BlockPos pos) {
        SoundUtil.serverPlayBlockSound(world, pos, SoundEvents.field_187646_bt);
        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, 0.5 + (double)pos.func_177958_n(), 0.25 + (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p(), 0.0, 0.1, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, 0.75 + (double)pos.func_177958_n(), 0.25 + (double)pos.func_177956_o(), 0.75 + (double)pos.func_177952_p(), 0.0, 0.05, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, 0.75 + (double)pos.func_177958_n(), 0.25 + (double)pos.func_177956_o(), 0.25 + (double)pos.func_177952_p(), 0.0, 0.05, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, 0.25 + (double)pos.func_177958_n(), 0.25 + (double)pos.func_177956_o(), 0.75 + (double)pos.func_177952_p(), 0.0, 0.05, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, 0.25 + (double)pos.func_177958_n(), 0.25 + (double)pos.func_177956_o(), 0.25 + (double)pos.func_177952_p(), 0.0, 0.05, 0.0, new int[0]);
    }

    private void createFlameParticle(World world, BlockPos pos, Random rand) {
        double yOffset = rand.nextDouble() * 0.35 + 0.35;
        double offAdj = (0.7 - yOffset) * 2.28571428;
        double xOffset = (rand.nextDouble() - 0.5) * offAdj + 0.5;
        double zOffset = (rand.nextDouble() - 0.5) * offAdj + 0.5;
        world.func_175688_a(EnumParticleTypes.FLAME, xOffset + (double)pos.func_177958_n(), yOffset + (double)pos.func_177956_o(), zOffset + (double)pos.func_177952_p(), 0.0, rand.nextDouble() * 0.015 + 0.005, 0.0, new int[0]);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public IProperty[] getIgnoredProperties() {
        return ignoredProperties;
    }
}

