/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.integration.crafttweaker;

import com.alcatrazescapee.alcatrazcore.inventory.ingredient.IRecipeIngredient;
import com.alcatrazescapee.alcatrazcore.inventory.recipe.IRecipeCore;
import com.alcatrazescapee.notreepunching.common.recipe.KnifeRecipe;
import com.alcatrazescapee.notreepunching.common.recipe.ModRecipes;
import com.alcatrazescapee.notreepunching.integration.crafttweaker.CraftTweakerPlugin;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.notreepunching.Knife")
public class CTKnifeRecipe {
    @ZenMethod
    public static void add(IIngredient input, IItemStack ... output) {
        KnifeRecipe recipe;
        ItemStack[] outputStack = (ItemStack[])Arrays.stream(output).map(CraftTweakerPlugin::toStack).toArray(ItemStack[]::new);
        if (input instanceof IOreDictEntry) {
            IOreDictEntry ore = (IOreDictEntry)input;
            recipe = new KnifeRecipe(ore.getName(), ore.getAmount(), outputStack);
        } else {
            recipe = new KnifeRecipe(CraftTweakerPlugin.toStack(input), outputStack);
        }
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                ModRecipes.addScheduledAction(() -> ModRecipes.KNIFE.add((IRecipeCore)recipe));
            }

            public String describe() {
                return "Adding knife recipe for " + recipe.getName();
            }
        });
    }

    @ZenMethod
    public static void remove(IIngredient input) {
        IRecipeIngredient ingredient;
        if (input instanceof IOreDictEntry) {
            IOreDictEntry ore = (IOreDictEntry)input;
            ingredient = IRecipeIngredient.of((String)ore.getName(), (int)ore.getAmount());
        } else {
            ingredient = IRecipeIngredient.of((ItemStack)CraftTweakerPlugin.toStack(input));
        }
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                ModRecipes.addScheduledAction(() -> ModRecipes.KNIFE.remove((Object)ingredient));
            }

            public String describe() {
                return "Removing knife recipe for " + ingredient.getName();
            }
        });
    }
}

