/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.common.items;

import com.alcatrazescapee.alcatrazcore.client.IModelProvider;
import com.alcatrazescapee.notreepunching.ModConfig;
import com.alcatrazescapee.notreepunching.NoTreePunching;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

@ParametersAreNonnullByDefault
public class ItemCeramicBucket
extends UniversalBucket
implements IModelProvider {
    public ItemCeramicBucket() {
        super(1000, ItemStack.field_190927_a, false);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString(), "inventory"));
    }

    public void func_150895_a(@Nullable CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        subItems.add((Object)new ItemStack((Item)this));
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            FluidStack fs = new FluidStack(fluid, this.getCapacity());
            ItemStack stack = new ItemStack((Item)this);
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (fluidHandler == null || fluidHandler.fill(fs, true) != fs.amount) continue;
            ItemStack filled = fluidHandler.getContainer();
            subItems.add((Object)filled);
        }
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            return I18n.func_74838_a((String)(this.func_77658_a() + ".name"));
        }
        return I18n.func_74837_a((String)(this.func_77658_a() + ".filled.name"), (Object[])new Object[]{fluidStack.getLocalizedName()});
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        FluidStack fluidStack = this.getFluid(heldItem);
        if (fluidStack != null) {
            ActionResult result = super.func_77659_a(world, player, hand);
            if (result.func_188397_a() == EnumActionResult.PASS) {
                player.func_184598_c(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
            }
            return result;
        }
        RayTraceResult target = this.func_77621_a(world, player, true);
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)heldItem);
        }
        BlockPos pos = target.func_178782_a();
        ItemStack singleBucket = heldItem.func_77946_l();
        singleBucket.func_190920_e(1);
        FluidActionResult filledResult = FluidUtil.tryPickUpFluid((ItemStack)singleBucket, (EntityPlayer)player, (World)world, (BlockPos)pos, (EnumFacing)target.field_178784_b);
        if (filledResult.isSuccess()) {
            ItemStack filledBucket = filledResult.result;
            if (player.field_71075_bZ.field_75098_d) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
            }
            heldItem.func_190918_g(1);
            if (heldItem.func_190926_b()) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)filledBucket);
            }
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)filledBucket);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)heldItem);
    }

    @Nonnull
    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack != null) {
            Fluid fluid;
            if (!worldIn.field_72995_K && (fluid = fluidStack.getFluid()) != null) {
                switch (fluid.getName()) {
                    case "milk": {
                        entityLiving.curePotionEffects(stack);
                        break;
                    }
                    case "lava": {
                        NoTreePunching.getLog().info("You fool! Why are you drinking lava!");
                    }
                }
            }
            return this.getEmpty();
        }
        return stack;
    }

    @Nullable
    public FluidStack getFluid(ItemStack stack) {
        IFluidHandler cap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (cap instanceof FluidHandlerCeramicBucket) {
            return ((FluidHandlerCeramicBucket)cap).getFluid();
        }
        return null;
    }

    @Nonnull
    public ItemStack getEmpty() {
        return new ItemStack((Item)this);
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerCeramicBucket(stack, 1000);
    }

    private static class FluidHandlerCeramicBucket
    extends FluidHandlerItemStackSimple {
        public FluidHandlerCeramicBucket(@Nonnull ItemStack container, int capacity) {
            super(container, capacity);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            for (String s : ModConfig.GENERAL.ceramicBucketValidFluids) {
                if (!s.equals(fluid.getFluid().getName())) continue;
                return true;
            }
            return false;
        }
    }
}

