/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.util.compat.jei;

import com.shultrea.rin.util.UpgradeRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;

public class UpgradeRecipeWrapper
implements IRecipeWrapper {
    private final ItemStack inputBook;
    private final ItemStack upgradeToken;
    private ItemStack outputBook = null;
    private ItemStack curseBook = null;
    private static final ItemStack bookTemplate = new ItemStack(Items.field_151134_bR);

    public UpgradeRecipeWrapper(UpgradeRecipe recipe, int enchLvlIn) {
        this.upgradeToken = recipe.getTokenCost();
        this.inputBook = bookTemplate.func_77946_l();
        ItemEnchantedBook.func_92115_a((ItemStack)this.inputBook, (EnchantmentData)new EnchantmentData(recipe.getInput(), enchLvlIn));
        Map<Enchantment, Integer> enchantsOut = recipe.getOutputStackEnchants(this.inputBook);
        Enchantment enchOut = recipe.getOutputEnchant();
        if (enchantsOut.size() != 1) {
            return;
        }
        if (!enchantsOut.containsKey(enchOut)) {
            return;
        }
        int enchLvlOut = enchantsOut.get(enchOut);
        if (enchLvlOut == -99) {
            return;
        }
        this.outputBook = bookTemplate.func_77946_l();
        ItemEnchantedBook.func_92115_a((ItemStack)this.outputBook, (EnchantmentData)new EnchantmentData(enchOut, enchLvlOut));
        UpgradeRecipe cursingRecipe = recipe.getCursingRecipe();
        if (cursingRecipe != null) {
            this.curseBook = bookTemplate.func_77946_l();
            int outputLvl = cursingRecipe.getOutputLvl(enchLvlIn);
            ItemEnchantedBook.func_92115_a((ItemStack)this.curseBook, (EnchantmentData)new EnchantmentData(cursingRecipe.getOutputEnchant(), outputLvl));
        }
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, Arrays.asList(this.inputBook, this.upgradeToken));
        if (this.curseBook == null) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.outputBook);
        } else {
            ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(Arrays.asList(this.outputBook, this.curseBook)));
        }
    }

    public static List<UpgradeRecipeWrapper> getWrappers(UpgradeRecipe recipe) {
        ArrayList<UpgradeRecipeWrapper> recipeWrappers = new ArrayList<UpgradeRecipeWrapper>();
        Enchantment enchIn = recipe.getInput();
        for (int enchLvlIn = enchIn.func_77319_d(); enchLvlIn <= enchIn.func_77325_b(); ++enchLvlIn) {
            if (recipe.canUpgrade(enchIn, enchLvlIn) == -99) continue;
            UpgradeRecipeWrapper wrapper = new UpgradeRecipeWrapper(recipe, enchLvlIn);
            if (wrapper.outputBook == null) continue;
            recipeWrappers.add(wrapper);
        }
        return recipeWrappers;
    }
}

